/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.mom.api.marshaller;

import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.eclipse.scout.rt.mom.api.marshaller.JsonMarshaller;
import org.eclipse.scout.rt.platform.Bean;

@Bean
public class JsonAsBytesMarshaller
extends JsonMarshaller {
    @Override
    public Object marshall(Object transferObject, Map<String, String> context) {
        String jsonText = (String)super.marshall(transferObject, context);
        if (jsonText == null) {
            return null;
        }
        return jsonText.getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public Object unmarshall(Object data, Map<String, String> context) {
        byte[] jsonBytes = (byte[])data;
        if (jsonBytes == null) {
            return null;
        }
        String jsonText = new String(jsonBytes, StandardCharsets.UTF_8);
        return super.unmarshall(jsonText, context);
    }

    @Override
    public int getMessageType() {
        return 2;
    }
}

