/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.mom.api;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.eclipse.scout.rt.mom.api.IDestination;
import org.eclipse.scout.rt.platform.Bean;

@Bean
public class PublishInput {
    public static final long INFINITELY = -1L;
    public static final int PRIORITY_NORMAL = 0;
    public static final int DELIVERY_MODE_NON_PERSISTENT = 1;
    public static final int DELIVERY_MODE_PERSISTENT = 2;
    private final Map<String, String> m_properties = new HashMap<String, String>();
    private int m_deliveryMode = 2;
    private int m_priority = 0;
    private long m_timeToLive = -1L;
    private long m_requestReplyTimeout = -1L;
    private boolean m_transactional = false;
    private IDestination<?> m_replyTo;

    public int getDeliveryMode() {
        return this.m_deliveryMode;
    }

    public PublishInput withDeliveryMode(int deliveryMode) {
        this.m_deliveryMode = deliveryMode;
        return this;
    }

    public Integer getPriority() {
        return this.m_priority;
    }

    public PublishInput withPriority(int priority) {
        this.m_priority = priority;
        return this;
    }

    public long getTimeToLive() {
        return this.m_timeToLive;
    }

    public PublishInput withTimeToLive(long timeToLive, TimeUnit unit) {
        this.m_timeToLive = unit.toMillis(timeToLive);
        return this;
    }

    public long getRequestReplyTimeout() {
        return this.m_requestReplyTimeout;
    }

    public PublishInput withRequestReplyTimeout(long timeout, TimeUnit unit) {
        this.m_requestReplyTimeout = unit.toMillis(timeout);
        return this;
    }

    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this.m_properties);
    }

    public PublishInput withProperty(String name, String value) {
        this.m_properties.put(name, value);
        return this;
    }

    public PublishInput withProperties(Map<String, String> props) {
        if (props != null) {
            for (Map.Entry<String, String> e : props.entrySet()) {
                this.withProperty(e.getKey(), e.getValue());
            }
        }
        return this;
    }

    public boolean isTransactional() {
        return this.m_transactional;
    }

    public PublishInput withTransactional(boolean transactional) {
        this.m_transactional = transactional;
        return this;
    }

    public IDestination<?> getReplyTo() {
        return this.m_replyTo;
    }

    public PublishInput withReplyTo(IDestination<?> replyTo) {
        this.m_replyTo = replyTo;
        return this;
    }
}

