/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.mom.api;

import org.eclipse.scout.rt.platform.util.ObjectUtility;

public interface IDestination<DTO> {
    public String getName();

    public IDestinationType getType();

    public IResolveMethod getResolveMethod();

    public static enum DestinationType implements IDestinationType
    {
        QUEUE,
        TOPIC;

    }

    public static interface IDestinationType {
    }

    @FunctionalInterface
    public static interface IResolveMethod {
        public String getIdentifier();
    }

    public static enum ResolveMethod implements IResolveMethod
    {
        DEFINE("define"),
        JNDI("jndi");

        private final String m_identifier;

        private ResolveMethod(String identifier) {
            this.m_identifier = identifier;
        }

        @Override
        public String getIdentifier() {
            return this.m_identifier;
        }

        public static IResolveMethod parse(String identifier) {
            ResolveMethod[] resolveMethodArray = ResolveMethod.values();
            int n = resolveMethodArray.length;
            int n2 = 0;
            while (n2 < n) {
                ResolveMethod value = resolveMethodArray[n2];
                if (ObjectUtility.equals((Object)identifier, (Object)value.getIdentifier())) {
                    return value;
                }
                ++n2;
            }
            return null;
        }
    }
}

