/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.mom.api;

import jakarta.annotation.PostConstruct;
import java.util.Map;
import org.eclipse.scout.rt.mom.api.AbstractMomTransport;
import org.eclipse.scout.rt.mom.api.IMomImplementor;
import org.eclipse.scout.rt.mom.api.marshaller.IMarshaller;
import org.eclipse.scout.rt.mom.api.marshaller.ObjectMarshaller;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.CreateImmediately;
import org.eclipse.scout.rt.platform.config.AbstractClassConfigProperty;
import org.eclipse.scout.rt.platform.config.AbstractMapConfigProperty;
import org.eclipse.scout.rt.platform.config.CONFIG;

@CreateImmediately
public class ClusterMom
extends AbstractMomTransport {
    @PostConstruct
    public void init() {
        this.getDelegate();
    }

    @Override
    protected Class<? extends IMomImplementor> getConfiguredImplementor() {
        return (Class)CONFIG.getPropertyValue(ClusterMomImplementorProperty.class);
    }

    @Override
    protected Map<String, String> getConfiguredEnvironment() {
        return (Map)CONFIG.getPropertyValue(ClusterMomEnvironmentProperty.class);
    }

    @Override
    protected IMarshaller getConfiguredDefaultMarshaller() {
        return (IMarshaller)BEANS.get(ObjectMarshaller.class);
    }

    public static class ClusterMomEnvironmentProperty
    extends AbstractMapConfigProperty {
        public String getKey() {
            return "scout.mom.cluster.environment";
        }

        public String description() {
            return "Contains the configuration to connect to the network or broker. This configuration is specific to the MOM implementor\nExample to connect to a peer based cluster, which is useful in development mode because there is no central broker:\nscout.mom.cluster.environment[scout.mom.name]=Scout Cluster MOM\nscout.mom.cluster.environment[scout.mom.connectionfactory.name]=ClusterMom\nscout.mom.cluster.environment[java.naming.factory.initial]=org.apache.activemq.jndi.ActiveMQInitialContextFactory\nscout.mom.cluster.environment[java.naming.provider.url]=failover:(peer://mom/cluster?persistent=false)\nscout.mom.cluster.environment[connectionFactoryNames]=ClusterMom";
        }
    }

    public static class ClusterMomImplementorProperty
    extends AbstractClassConfigProperty<IMomImplementor> {
        public String getKey() {
            return "scout.mom.cluster.implementor";
        }

        public String description() {
            return String.format("Specifies the MOM implementor.\nExample to work with a JMS based implementor:\n%s=org.eclipse.scout.rt.mom.jms.JmsMomImplementor", this.getKey());
        }
    }
}

