/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.jackson.dataobject.id;

import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import java.io.IOException;
import org.eclipse.scout.rt.dataobject.id.IId;
import org.eclipse.scout.rt.jackson.dataobject.ScoutDataObjectModuleContext;
import org.eclipse.scout.rt.jackson.dataobject.id.AbstractIdCodecMapKeyDeserializer;

public class UnqualifiedIIdMapKeyDeserializer
extends AbstractIdCodecMapKeyDeserializer {
    protected final Class<? extends IId> m_idClass;

    public UnqualifiedIIdMapKeyDeserializer(ScoutDataObjectModuleContext moduleContext, Class<? extends IId> idClass) {
        super(moduleContext);
        this.m_idClass = idClass;
    }

    public Object deserializeKey(String key, DeserializationContext ctxt) throws IOException {
        try {
            return this.idCodec().fromUnqualified(this.m_idClass, key, this.idCodecFlags());
        }
        catch (RuntimeException e) {
            if (this.m_moduleContext.isLenientMode()) {
                return key;
            }
            throw InvalidFormatException.from(null, (String)("Failed to deserialize unqualified IId map key: " + e.getMessage()), (Object)key, this.m_idClass);
        }
    }
}

