/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.jackson.dataobject.id;

import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import java.io.IOException;
import org.eclipse.scout.rt.dataobject.id.IId;
import org.eclipse.scout.rt.dataobject.id.IdCodec;
import org.eclipse.scout.rt.jackson.dataobject.ScoutDataObjectModuleContext;
import org.eclipse.scout.rt.jackson.dataobject.id.AbstractIdCodecMapKeyDeserializer;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.ObjectUtility;

public class QualifiedIIdMapKeyDeserializer
extends AbstractIdCodecMapKeyDeserializer {
    protected final Class<? extends IId> m_idClass;

    public QualifiedIIdMapKeyDeserializer(ScoutDataObjectModuleContext moduleContext, Class<? extends IId> idClass) {
        super(moduleContext);
        this.m_idClass = idClass;
    }

    public Object deserializeKey(String key, DeserializationContext ctxt) throws IOException {
        try {
            IId id = this.idCodec().fromQualified(key, this.idCodecFlags());
            if (!ObjectUtility.isOneOf((Object)IdCodec.IdCodecFlag.LENIENT, this.idCodecFlags())) {
                Assertions.assertInstance((Object)id, this.m_idClass);
            }
            return id;
        }
        catch (RuntimeException e) {
            throw InvalidFormatException.from(null, (String)("Failed to deserialize qualified IId map key: " + e.getMessage()), (Object)key, this.m_idClass);
        }
    }
}

