/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.jackson.dataobject.id;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.util.Collections;
import java.util.Set;
import org.eclipse.scout.rt.dataobject.id.IdCodec;
import org.eclipse.scout.rt.jackson.dataobject.ScoutDataObjectModuleContext;
import org.eclipse.scout.rt.jackson.dataobject.id.IdCodecUtility;
import org.eclipse.scout.rt.platform.util.LazyValue;

public abstract class AbstractIdCodecDeserializer<T>
extends StdDeserializer<T> {
    private static final long serialVersionUID = 1L;
    protected final ScoutDataObjectModuleContext m_moduleContext;
    protected final LazyValue<IdCodec> m_idCodec = new LazyValue(IdCodec.class);
    protected final LazyValue<Set<IdCodec.IIdCodecFlag>> m_idCodecFlags = new LazyValue(() -> Collections.unmodifiableSet(this.computeIdCodecFlags()));

    public AbstractIdCodecDeserializer(ScoutDataObjectModuleContext moduleContext, Class<?> valueClass) {
        super(valueClass);
        this.m_moduleContext = moduleContext;
    }

    public AbstractIdCodecDeserializer(ScoutDataObjectModuleContext moduleContext, JavaType valueType) {
        super(valueType);
        this.m_moduleContext = moduleContext;
    }

    protected ScoutDataObjectModuleContext moduleContext() {
        return this.m_moduleContext;
    }

    protected IdCodec idCodec() {
        return (IdCodec)this.m_idCodec.get();
    }

    protected Set<IdCodec.IIdCodecFlag> computeIdCodecFlags() {
        return IdCodecUtility.getIdCodecFlags(this.moduleContext());
    }

    protected Set<IdCodec.IIdCodecFlag> idCodecFlags() {
        return (Set)this.m_idCodecFlags.get();
    }
}

