/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.jackson.dataobject.enumeration;

import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import java.io.IOException;
import org.eclipse.scout.rt.dataobject.enumeration.EnumResolver;
import org.eclipse.scout.rt.dataobject.enumeration.IEnum;
import org.eclipse.scout.rt.jackson.dataobject.ScoutDataObjectModuleContext;
import org.eclipse.scout.rt.platform.util.LazyValue;

public class EnumMapKeyDeserializer
extends KeyDeserializer {
    protected final LazyValue<EnumResolver> m_enumResolver = new LazyValue(EnumResolver.class);
    protected final ScoutDataObjectModuleContext m_moduleContext;
    protected final Class<? extends IEnum> m_enumClass;

    public EnumMapKeyDeserializer(ScoutDataObjectModuleContext moduleContext, Class<? extends IEnum> enumClass) {
        this.m_moduleContext = moduleContext;
        this.m_enumClass = enumClass;
    }

    public Object deserializeKey(String key, DeserializationContext ctxt) throws IOException {
        try {
            return ((EnumResolver)this.m_enumResolver.get()).resolve(this.m_enumClass, key);
        }
        catch (RuntimeException e) {
            if (this.m_moduleContext.isLenientMode()) {
                return key;
            }
            throw InvalidFormatException.from(null, (String)("Failed to deserialize map key IEnum: " + e.getMessage()), (Object)key, this.m_enumClass);
        }
    }
}

