/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.jackson.dataobject;

import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.eclipse.scout.rt.dataobject.DoCollection;
import org.eclipse.scout.rt.dataobject.DoList;
import org.eclipse.scout.rt.dataobject.DoSet;
import org.eclipse.scout.rt.dataobject.DoValue;
import org.eclipse.scout.rt.jackson.dataobject.AttributeType;
import org.eclipse.scout.rt.platform.exception.PlatformException;
import org.eclipse.scout.rt.platform.util.ObjectUtility;

public final class TypeFactoryUtility {
    private TypeFactoryUtility() {
    }

    public static AttributeType toAttributeType(ParameterizedType parametrizedType) {
        return TypeFactoryUtility.toAttributeType(parametrizedType, null);
    }

    public static AttributeType toAttributeType(ParameterizedType parametrizedType, JsonToken currentToken) {
        if (ObjectUtility.isOneOf((Object)parametrizedType.getRawType(), DoList.class, (Object[])new Object[]{DoSet.class, DoCollection.class})) {
            JavaType listItemsType = TypeFactory.defaultInstance().constructType(parametrizedType.getActualTypeArguments()[0]);
            return AttributeType.ofDoCollection(TypeFactory.defaultInstance().constructParametricType((Class)parametrizedType.getRawType(), new JavaType[]{listItemsType}));
        }
        if (DoValue.class == parametrizedType.getRawType()) {
            Object typeArg = parametrizedType.getActualTypeArguments()[0];
            if (typeArg == Object.class && currentToken == JsonToken.START_ARRAY) {
                typeArg = DoList.class;
            }
            return AttributeType.ofDoValue(TypeFactory.defaultInstance().constructType((Type)typeArg));
        }
        throw new PlatformException("Could not convert type {}, only DoValue<?>, DoList<?>, DoSet<?> and DoCollection<?> supported", new Object[]{parametrizedType});
    }
}

