/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.jackson.dataobject;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.StreamReadConstraints;
import com.fasterxml.jackson.core.StreamWriteConstraints;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.scout.rt.dataobject.IDataObject;
import org.eclipse.scout.rt.dataobject.IDataObjectMapper;
import org.eclipse.scout.rt.jackson.dataobject.ScoutDataObjectModule;
import org.eclipse.scout.rt.jackson.dataobject.ScoutDataObjectModuleContext;
import org.eclipse.scout.rt.platform.ApplicationScoped;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.config.AbstractConfigProperty;
import org.eclipse.scout.rt.platform.config.CONFIG;
import org.eclipse.scout.rt.platform.config.ConfigUtility;
import org.eclipse.scout.rt.platform.exception.PlatformException;
import org.eclipse.scout.rt.platform.exception.PlatformExceptionTranslator;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.LazyValue;
import org.eclipse.scout.rt.platform.util.ObjectUtility;
import org.eclipse.scout.rt.platform.util.TypeCastUtility;

@ApplicationScoped
public class JacksonDataObjectMapper
implements IDataObjectMapper {
    private final LazyValue<ObjectMapper> m_objectMapper = new LazyValue(() -> this.createObjectMapperInstance(false));
    private final LazyValue<ObjectMapper> m_rawObjectMapper = new LazyValue(() -> this.createObjectMapperInstance(true));

    public <T> T readValue(InputStream inputStream, Class<T> valueType) {
        Assertions.assertNotNull((Object)inputStream, (String)"Input stream must not be null", (Object[])new Object[0]);
        try {
            return (T)((ObjectMapper)this.m_objectMapper.get()).readValue(inputStream, valueType);
        }
        catch (IOException e) {
            throw ((PlatformExceptionTranslator)BEANS.get(PlatformExceptionTranslator.class)).translate((Throwable)e);
        }
    }

    public <T> T readValue(String value, Class<T> valueType) {
        if (value == null) {
            return null;
        }
        try {
            return (T)((ObjectMapper)this.m_objectMapper.get()).readValue(value, valueType);
        }
        catch (IOException e) {
            throw ((PlatformExceptionTranslator)BEANS.get(PlatformExceptionTranslator.class)).translate((Throwable)e);
        }
    }

    public IDataObject readValueRaw(InputStream inputStream) {
        Assertions.assertNotNull((Object)inputStream, (String)"Input stream must not be null", (Object[])new Object[0]);
        try {
            return (IDataObject)((ObjectMapper)this.m_rawObjectMapper.get()).readValue(inputStream, IDataObject.class);
        }
        catch (IOException e) {
            throw ((PlatformExceptionTranslator)BEANS.get(PlatformExceptionTranslator.class)).translate((Throwable)e);
        }
    }

    public IDataObject readValueRaw(String value) {
        if (value == null) {
            return null;
        }
        try {
            return (IDataObject)((ObjectMapper)this.m_rawObjectMapper.get()).readValue(value, IDataObject.class);
        }
        catch (IOException e) {
            throw ((PlatformExceptionTranslator)BEANS.get(PlatformExceptionTranslator.class)).translate((Throwable)e);
        }
    }

    public void writeValue(OutputStream outputStream, Object value) {
        Assertions.assertNotNull((Object)outputStream, (String)"Output stream must not be null", (Object[])new Object[0]);
        if (value == null) {
            return;
        }
        try {
            ((ObjectMapper)this.m_objectMapper.get()).writeValue(outputStream, value);
        }
        catch (IOException e) {
            throw ((PlatformExceptionTranslator)BEANS.get(PlatformExceptionTranslator.class)).translate((Throwable)e);
        }
    }

    public String writeValue(Object value) {
        if (value == null) {
            return null;
        }
        try {
            return ((ObjectMapper)this.m_objectMapper.get()).writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            throw ((PlatformExceptionTranslator)BEANS.get(PlatformExceptionTranslator.class)).translate((Throwable)e);
        }
    }

    @Deprecated
    public ObjectMapper getObjectMapper() {
        return (ObjectMapper)this.m_objectMapper.get();
    }

    protected ObjectMapper createObjectMapperInstance(boolean ignoreTypeAttribute) {
        JsonFactory jsonFactory = JsonFactory.builder().streamReadConstraints((StreamReadConstraints)CONFIG.getPropertyValue(StreamReadConstraintsConfigProperty.class)).streamWriteConstraints((StreamWriteConstraints)CONFIG.getPropertyValue(StreamWriteConstraintsConfigProperty.class)).build();
        ObjectMapper om = new ObjectMapper(jsonFactory);
        ScoutDataObjectModule scoutDataObjectModule = ((ScoutDataObjectModule)((Object)BEANS.get(ScoutDataObjectModule.class))).withIgnoreTypeAttribute(ignoreTypeAttribute);
        this.prepareScoutDataModuleContext(scoutDataObjectModule.getModuleContext());
        om.registerModule((Module)scoutDataObjectModule);
        om.setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS"));
        om.deactivateDefaultTyping();
        om.enable(new MapperFeature[]{MapperFeature.BLOCK_UNSAFE_POLYMORPHIC_BASE_TYPES});
        return om;
    }

    protected void prepareScoutDataModuleContext(ScoutDataObjectModuleContext moduleContext) {
    }

    public static class StreamReadConstraintsConfigProperty
    extends AbstractConfigProperty<StreamReadConstraints, Map<String, String>> {
        static final String MAX_NESTING_DEPTH = "maxNestingDepth";
        static final String MAX_DOCUMENT_LENGTH = "maxDocumentLength";
        static final String MAX_NAME_LENGTH = "maxNameLength";
        static final String MAX_NUMBER_LENGTH = "maxNumberLength";
        static final String MAX_STRING_LENGTH = "maxStringLength";
        public static final int DEFAULT_MAX_STRING_LEN = 100000000;

        public String getKey() {
            return "scout.dataobject.jackson.streamReadConstraints";
        }

        public String description() {
            return String.format("Jackson constraints to use for JSON reading.\nMap property with the keys as follows:\n- %s: Sets the maximum nesting depth. The depth is a count of objects and arrays that have not been closed, `{` and `[` respectively. (default: %d)\n- %s: Sets the maximum allowed document length (for positive values over 0) or indicate that any length is acceptable (0 or negative number). The length is in input units of the input source, that is, in bytes or chars. (default: %d)\n- %s: Sets the maximum name length (in chars or bytes, depending on input context). (default: %d)\n- %s: Sets the maximum number length (in chars or bytes, depending on input context). (default: %d)\n- %s: Sets the maximum string length for a single attribute value of type text (in chars or bytes, depending on input context). (default: %d)\n", MAX_NESTING_DEPTH, 1000, MAX_DOCUMENT_LENGTH, -1L, MAX_NAME_LENGTH, 50000, MAX_NUMBER_LENGTH, 1000, MAX_STRING_LENGTH, 100000000);
        }

        public Map<String, String> readFromSource(String namespace) {
            return ConfigUtility.getPropertyMap((String)this.getKey(), null, (String)namespace);
        }

        public StreamReadConstraints getDefaultValue() {
            return this.parse(Collections.emptyMap());
        }

        protected StreamReadConstraints parse(Map<String, String> value) {
            HashSet<String> invalidMapKeys = new HashSet<String>(value.keySet());
            Arrays.asList(MAX_NESTING_DEPTH, MAX_DOCUMENT_LENGTH, MAX_NAME_LENGTH, MAX_NUMBER_LENGTH, MAX_STRING_LENGTH).forEach(invalidMapKeys::remove);
            if (!invalidMapKeys.isEmpty()) {
                throw new PlatformException("Invalid values for map property {}: {}", new Object[]{this.getKey(), invalidMapKeys});
            }
            return StreamReadConstraints.builder().maxNestingDepth(((Integer)ObjectUtility.nvl((Object)((Integer)TypeCastUtility.castValue((Object)value.get(MAX_NESTING_DEPTH), Integer.class)), (Object)1000)).intValue()).maxDocumentLength(((Long)ObjectUtility.nvl((Object)((Long)TypeCastUtility.castValue((Object)value.get(MAX_DOCUMENT_LENGTH), Long.class)), (Object)-1L)).longValue()).maxNameLength(((Integer)ObjectUtility.nvl((Object)((Integer)TypeCastUtility.castValue((Object)value.get(MAX_NAME_LENGTH), Integer.class)), (Object)50000)).intValue()).maxNumberLength(((Integer)ObjectUtility.nvl((Object)((Integer)TypeCastUtility.castValue((Object)value.get(MAX_NUMBER_LENGTH), Integer.class)), (Object)1000)).intValue()).maxStringLength(((Integer)ObjectUtility.nvl((Object)((Integer)TypeCastUtility.castValue((Object)value.get(MAX_STRING_LENGTH), Integer.class)), (Object)100000000)).intValue()).build();
        }
    }

    public static class StreamWriteConstraintsConfigProperty
    extends AbstractConfigProperty<StreamWriteConstraints, Map<String, String>> {
        private static final String MAX_NESTING_DEPTH = "maxNestingDepth";

        public String getKey() {
            return "scout.dataobject.jackson.streamWriteConstraints";
        }

        public String description() {
            return String.format("Jackson constraints to use for JSON writing.\nMap property with the keys as follows:\n- %s: Sets the maximum nesting depth. The depth is a count of objects and arrays that have not been closed, `{` and `[` respectively. (default: %d)\n", MAX_NESTING_DEPTH, 1000);
        }

        public Map<String, String> readFromSource(String namespace) {
            return ConfigUtility.getPropertyMap((String)this.getKey(), null, (String)namespace);
        }

        public StreamWriteConstraints getDefaultValue() {
            return this.parse(Collections.emptyMap());
        }

        protected StreamWriteConstraints parse(Map<String, String> value) {
            HashSet<String> invalidMapKeys = new HashSet<String>(value.keySet());
            Arrays.asList(MAX_NESTING_DEPTH).forEach(invalidMapKeys::remove);
            if (!invalidMapKeys.isEmpty()) {
                throw new PlatformException("Invalid values for map property {}: {}", new Object[]{this.getKey(), invalidMapKeys});
            }
            return StreamWriteConstraints.builder().maxNestingDepth(((Integer)ObjectUtility.nvl((Object)((Integer)TypeCastUtility.castValue((Object)value.get(MAX_NESTING_DEPTH), Integer.class)), (Object)1000)).intValue()).build();
        }
    }
}

