/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.jackson.dataobject;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.WritableTypeId;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.databind.type.MapType;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.scout.rt.dataobject.DataObjectInventory;
import org.eclipse.scout.rt.dataobject.DoEntity;
import org.eclipse.scout.rt.dataobject.DoValue;
import org.eclipse.scout.rt.dataobject.IDataObject;
import org.eclipse.scout.rt.dataobject.IDoCollection;
import org.eclipse.scout.rt.dataobject.IDoEntity;
import org.eclipse.scout.rt.dataobject.IDoEntityContribution;
import org.eclipse.scout.rt.jackson.dataobject.AttributeType;
import org.eclipse.scout.rt.jackson.dataobject.ScoutDataObjectModuleContext;
import org.eclipse.scout.rt.jackson.dataobject.TypeFactoryUtility;
import org.eclipse.scout.rt.platform.namespace.NamespaceVersion;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.LazyValue;

public class DoEntitySerializer
extends StdSerializer<IDoEntity> {
    private static final long serialVersionUID = 1L;
    protected final LazyValue<DataObjectInventory> m_dataObjectInventory = new LazyValue(DataObjectInventory.class);
    protected final ScoutDataObjectModuleContext m_context;

    public DoEntitySerializer(ScoutDataObjectModuleContext context, JavaType type) {
        super(type);
        this.m_context = context;
    }

    public void serialize(IDoEntity entity, JsonGenerator gen, SerializerProvider provider) throws IOException {
        gen.writeStartObject();
        this.serializeAttributes(entity, gen, provider);
        gen.writeEndObject();
    }

    public void serializeWithType(IDoEntity entity, JsonGenerator gen, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(gen, typeSer.typeId((Object)entity, JsonToken.START_OBJECT));
        this.serializeAttributes(entity, gen, provider);
        typeSer.writeTypeSuffix(gen, typeIdDef);
    }

    protected void serializeAttributes(IDoEntity entity, JsonGenerator gen, SerializerProvider provider) throws IOException {
        this.serializeTypeVersion(gen, entity);
        TreeMap sortedMap = new TreeMap(this.m_context.getComparator());
        sortedMap.putAll(entity.allNodes());
        for (Map.Entry e : sortedMap.entrySet()) {
            gen.setCurrentValue((Object)entity);
            this.serializeAttribute(e.getKey(), e.getValue(), gen, provider);
        }
        this.serializeContributions(gen, entity, provider);
    }

    protected void serializeTypeVersion(JsonGenerator gen, IDoEntity entity) throws IOException {
        NamespaceVersion typeVersion = ((DataObjectInventory)this.m_dataObjectInventory.get()).getTypeVersion(entity.getClass());
        if (typeVersion != null) {
            gen.writeFieldName(this.m_context.getTypeVersionAttributeName());
            gen.writeString(typeVersion.unwrap());
        }
    }

    protected void serializeContributions(JsonGenerator gen, IDoEntity entity, SerializerProvider provider) throws IOException {
        if (entity.hasContributions()) {
            Collection contributions = entity.getAllContributions();
            this.validateContributions(entity, contributions);
            gen.writeObjectField(this.m_context.getContributionsAttributeName(), (Object)contributions);
        }
    }

    protected void serializeAttribute(String attributeName, Object obj, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (obj instanceof DoValue) {
            obj = ((DoValue)obj).get();
        }
        if (obj == null) {
            gen.writeObjectField(attributeName, null);
        } else if (obj instanceof Collection || obj instanceof IDoCollection) {
            gen.writeObjectField(attributeName, obj);
        } else if (obj instanceof Map) {
            this.serializeMap(attributeName, (Map)obj, gen, provider);
        } else if (obj.getClass() == DoEntity.class) {
            gen.writeObjectField(attributeName, obj);
        } else {
            JavaType declaredAttributeType = this.getAttributeType(attributeName).map(AttributeType::getJavaType).orElse(null);
            if (this.isSerializeByDeclaredType(declaredAttributeType, obj.getClass())) {
                this.serializeTypedAttribute(attributeName, obj, gen, provider, declaredAttributeType);
            } else {
                gen.writeObjectField(attributeName, obj);
            }
        }
    }

    protected void serializeMap(String attributeName, Map<?, ?> map, JsonGenerator gen, SerializerProvider provider) throws IOException {
        Optional<AttributeType> typeOpt = this.getAttributeType(attributeName);
        JavaType keyType = null;
        JsonSerializer keySerializer = null;
        JavaType valueType = null;
        JsonSerializer valueSerializer = null;
        if (typeOpt.isPresent()) {
            MapType mapType = (MapType)typeOpt.get().getJavaType();
            keyType = mapType.getKeyType();
            keySerializer = provider.findKeySerializer(keyType, null);
            valueType = mapType.getContentType();
            if (valueType.getRawClass() != Object.class) {
                valueSerializer = provider.findTypedValueSerializer(valueType, true, null);
            }
        }
        gen.writeFieldName(attributeName);
        gen.writeStartObject();
        gen.setCurrentValue(map);
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            Object key = entry.getKey();
            if (key == null) {
                provider.getDefaultNullKeySerializer().serialize(key, gen, provider);
            } else {
                JsonSerializer ser = keySerializer == null || this.m_context.isLenientMode() && !keyType.isTypeOrSuperTypeOf(key.getClass()) ? provider.findKeySerializer(key.getClass(), null) : keySerializer;
                ser.serialize(key, gen, provider);
            }
            Object value = entry.getValue();
            if (valueSerializer != null && value != null && this.isSerializeByDeclaredType(valueType, value.getClass())) {
                valueSerializer.serialize(value, gen, provider);
                continue;
            }
            gen.writeObject(value);
        }
        gen.writeEndObject();
    }

    protected boolean isSerializeByDeclaredType(JavaType declaredAttributeType, Class<?> attributeType) {
        return declaredAttributeType != null && (!this.m_context.isLenientMode() || declaredAttributeType.isTypeOrSuperTypeOf(attributeType)) && !declaredAttributeType.isTypeOrSubTypeOf(IDataObject.class);
    }

    protected void serializeTypedAttribute(String attributeName, Object obj, JsonGenerator gen, SerializerProvider provider, JavaType type) throws IOException {
        JsonSerializer ser = provider.findTypedValueSerializer(type, true, null);
        gen.writeFieldName(attributeName);
        ser.serialize(obj, gen, provider);
    }

    protected Optional<AttributeType> getAttributeType(String attributeName) {
        return ((DataObjectInventory)this.m_dataObjectInventory.get()).getAttributeDescription(this.handledType(), attributeName).map(a -> TypeFactoryUtility.toAttributeType(a.getType())).filter(AttributeType::isKnown);
    }

    protected void validateContributions(IDoEntity doEntity, Collection<IDoEntity> contributions) {
        for (IDoEntity contribution0 : contributions) {
            if (!(contribution0 instanceof IDoEntityContribution)) continue;
            IDoEntityContribution contribution = (IDoEntityContribution)contribution0;
            Set containerClasses = ((DataObjectInventory)this.m_dataObjectInventory.get()).getContributionContainers(contribution.getClass());
            Class<?> contributionClass = contribution.getClass();
            Assertions.assertTrue((boolean)containerClasses.stream().anyMatch(containerClass -> containerClass.isInstance(doEntity)), (String)"{} is not a valid container class of {}", (Object[])new Object[]{doEntity.getClass().getSimpleName(), contributionClass.getSimpleName()});
        }
    }
}

