/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.jackson.dataobject;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.Optional;
import org.eclipse.scout.rt.dataobject.DataObjectInventory;
import org.eclipse.scout.rt.dataobject.IDataObject;
import org.eclipse.scout.rt.dataobject.IDoEntity;
import org.eclipse.scout.rt.jackson.dataobject.AttributeType;
import org.eclipse.scout.rt.jackson.dataobject.ScoutDataObjectModuleContext;
import org.eclipse.scout.rt.jackson.dataobject.TypeFactoryUtility;
import org.eclipse.scout.rt.platform.util.LazyValue;

public class DoCollectionSerializer<COLLECTION extends Iterable<?>>
extends StdSerializer<COLLECTION> {
    private static final long serialVersionUID = 1L;
    protected final LazyValue<DataObjectInventory> m_dataObjectInventory = new LazyValue(DataObjectInventory.class);
    protected final ScoutDataObjectModuleContext m_context;

    public DoCollectionSerializer(ScoutDataObjectModuleContext context, JavaType type) {
        super(type);
        this.m_context = context;
    }

    public void serialize(COLLECTION value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        this.serializeList((Iterable<?>)value, gen, provider);
    }

    public void serializeWithType(COLLECTION value, JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
        this.serializeList((Iterable<?>)value, gen, serializers);
    }

    protected void serializeList(Iterable<?> value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        JavaType listElementType = null;
        JsonSerializer serializer = null;
        JsonStreamContext ctx = gen.getOutputContext();
        if (ctx.getCurrentValue() instanceof IDoEntity) {
            String attributeName = ctx.getCurrentName();
            Optional<AttributeType> typeOpt = this.getAttributeType(((IDoEntity)ctx.getCurrentValue()).getClass(), attributeName);
            if (typeOpt.isPresent() && (listElementType = typeOpt.get().getJavaType().getBindings().getBoundType(0)) != null && listElementType.getRawClass() != Object.class) {
                serializer = provider.findTypedValueSerializer(listElementType, true, null);
            }
        }
        gen.writeStartArray();
        gen.setCurrentValue(value);
        for (Object item : value) {
            if (!(serializer == null || item == null || this.m_context.isLenientMode() && !listElementType.isTypeOrSuperTypeOf(item.getClass()) || listElementType.isTypeOrSubTypeOf(IDataObject.class))) {
                serializer.serialize(item, gen, provider);
                continue;
            }
            gen.writeObject(item);
        }
        gen.writeEndArray();
    }

    protected Optional<AttributeType> getAttributeType(Class<? extends IDoEntity> entityClass, String attributeName) {
        return ((DataObjectInventory)this.m_dataObjectInventory.get()).getAttributeDescription(entityClass, attributeName).map(a -> TypeFactoryUtility.toAttributeType(a.getType())).filter(AttributeType::isKnown);
    }

    public boolean isEmpty(SerializerProvider provider, COLLECTION value) {
        return !value.iterator().hasNext();
    }
}

