/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.jackson.dataobject;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.function.Supplier;
import org.eclipse.scout.rt.dataobject.DoEntity;
import org.eclipse.scout.rt.dataobject.IDoCollection;
import org.eclipse.scout.rt.platform.util.ObjectUtility;

public class DoCollectionDeserializer<COLLECTION_NODE extends IDoCollection<?, ?>>
extends StdDeserializer<COLLECTION_NODE> {
    private static final long serialVersionUID = 1L;
    private final JavaType m_collectionType;
    private final Supplier<IDoCollection<Object, ? extends Collection<Object>>> m_nodeSupplier;

    public DoCollectionDeserializer(JavaType type, Supplier<IDoCollection<Object, ? extends Collection<Object>>> nodeSupplier) {
        super(type);
        this.m_collectionType = type;
        this.m_nodeSupplier = nodeSupplier;
    }

    public COLLECTION_NODE deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        return this.deserializeInternal(p, ctxt, this.m_nodeSupplier.get());
    }

    protected COLLECTION_NODE deserializeInternal(JsonParser p, DeserializationContext ctxt, IDoCollection<Object, ? extends Collection<Object>> collection) throws IOException {
        p.setCurrentValue(collection);
        JsonToken t = p.nextToken();
        while (t != JsonToken.END_ARRAY) {
            ResolvedType elementType = this.resolveListElementType(p);
            Object element = p.getCodec().readValue(p, elementType);
            collection.add(element);
            t = p.nextToken();
        }
        return (COLLECTION_NODE)collection;
    }

    protected ResolvedType resolveListElementType(JsonParser p) {
        if (p.getCurrentToken() == JsonToken.START_OBJECT) {
            JavaType collectionItemType = this.m_collectionType.getBindings().getBoundType(0);
            if (collectionItemType == null || collectionItemType.getRawClass() == Object.class) {
                return TypeFactory.defaultInstance().constructType(DoEntity.class);
            }
            return collectionItemType;
        }
        return (ResolvedType)ObjectUtility.nvl((Object)this.m_collectionType.getBindings().getBoundType(0), (Object)this.resolveFallbackListElementType(p));
    }

    protected ResolvedType resolveFallbackListElementType(JsonParser p) {
        if (p.getCurrentToken() == JsonToken.VALUE_NUMBER_FLOAT) {
            return TypeFactory.defaultInstance().constructType(BigDecimal.class);
        }
        return TypeFactory.unknownType();
    }

    public Object deserializeWithType(JsonParser p, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException {
        return this.deserialize(p, ctxt);
    }

    public COLLECTION_NODE getNullValue(DeserializationContext ctxt) {
        return (COLLECTION_NODE)this.m_nodeSupplier.get();
    }
}

