/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.jackson.dataobject;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import org.eclipse.scout.rt.platform.resource.BinaryResource;
import org.eclipse.scout.rt.platform.resource.BinaryResources;

public class DoBinaryResourceDeserializer
extends StdDeserializer<BinaryResource> {
    private static final long serialVersionUID = 1L;

    protected DoBinaryResourceDeserializer() {
        super(BinaryResource.class);
    }

    protected String getNullableText(JsonNode node, String fieldName) {
        JsonNode field = node.get(fieldName);
        if (field == null) {
            return null;
        }
        return field.isNull() ? null : field.asText();
    }

    public BinaryResource deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        BinaryResources builder = BinaryResources.create();
        JsonNode fieldNode = node.get("content");
        if (fieldNode != null) {
            builder.withContent(fieldNode.binaryValue());
        }
        if ((fieldNode = node.get("lastModified")) != null) {
            builder.withLastModified(fieldNode.asLong());
        }
        builder.withContentType(this.getNullableText(node, "contentType")).withFilename(this.getNullableText(node, "filename")).withCharset(this.getNullableText(node, "charset"));
        fieldNode = node.get("cachingAllowed");
        if (fieldNode != null) {
            builder.withCachingAllowed(fieldNode.asBoolean());
        }
        if ((fieldNode = node.get("cacheMaxAge")) != null) {
            builder.withCacheMaxAge(fieldNode.asInt());
        }
        return builder.build();
    }
}

