/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.jackson.dataobject;

import com.fasterxml.jackson.core.JsonToken;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.eclipse.scout.rt.dataobject.DataObjectInventory;
import org.eclipse.scout.rt.dataobject.DoEntity;
import org.eclipse.scout.rt.dataobject.IDoEntity;
import org.eclipse.scout.rt.jackson.dataobject.AttributeType;
import org.eclipse.scout.rt.jackson.dataobject.IDoEntityDeserializerTypeStrategy;
import org.eclipse.scout.rt.jackson.dataobject.TypeFactoryUtility;
import org.eclipse.scout.rt.platform.Bean;
import org.eclipse.scout.rt.platform.namespace.NamespaceVersion;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.LazyValue;

@Bean
public class DefaultDoEntityDeserializerTypeStrategy
implements IDoEntityDeserializerTypeStrategy {
    protected final LazyValue<DataObjectInventory> m_dataObjectInventory = new LazyValue(DataObjectInventory.class);

    @Override
    public Class<? extends IDoEntity> resolveTypeName(String entityType) {
        return ((DataObjectInventory)this.m_dataObjectInventory.get()).fromTypeName(entityType);
    }

    @Override
    public String resolveTypeVersion(Class<? extends IDoEntity> entityClass) {
        NamespaceVersion typeVersion = ((DataObjectInventory)this.m_dataObjectInventory.get()).getTypeVersion(entityClass);
        return typeVersion == null ? null : typeVersion.unwrap();
    }

    @Override
    public Optional<AttributeType> resolveAttributeType(Class<? extends IDoEntity> entityClass, String attributeName, JsonToken currentToken) {
        return ((DataObjectInventory)this.m_dataObjectInventory.get()).getAttributeDescription(entityClass, attributeName).map(a -> TypeFactoryUtility.toAttributeType(a.getType(), currentToken)).filter(AttributeType::isKnown);
    }

    @Override
    public void putContributions(IDoEntity doEntity, String attributeName, Collection<?> contributions) {
        if (CollectionUtility.isEmpty(contributions)) {
            return;
        }
        if (doEntity.getClass() == DoEntity.class) {
            doEntity.putList(attributeName, (List)CollectionUtility.arrayList(contributions));
        } else {
            doEntity.getAllContributions().addAll(contributions);
        }
    }
}

