/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.jackson.dataobject;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.type.WritableTypeId;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.jsontype.impl.AsPropertyTypeSerializer;
import com.fasterxml.jackson.databind.jsontype.impl.StdTypeResolverBuilder;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.Collection;
import org.eclipse.scout.rt.dataobject.DataObjectInventory;
import org.eclipse.scout.rt.platform.Bean;
import org.eclipse.scout.rt.platform.util.LazyValue;

@Bean
public class DataObjectTypeResolverBuilder
extends StdTypeResolverBuilder {
    private final LazyValue<DataObjectInventory> m_dataObjectInventory = new LazyValue(DataObjectInventory.class);

    public TypeDeserializer buildTypeDeserializer(DeserializationConfig config, JavaType baseType, Collection<NamedType> subtypes) {
        return this.useForType(baseType) ? super.buildTypeDeserializer(config, baseType, subtypes) : null;
    }

    public TypeSerializer buildTypeSerializer(SerializationConfig config, JavaType baseType, Collection<NamedType> subtypes) {
        return this.useForType(baseType) ? new DataObjectAsPropertyTypeSerializer(this._customIdResolver, this.getTypeProperty()) : null;
    }

    protected boolean useForType(JavaType t) {
        if (t.getRawClass().isInterface() || Modifier.isAbstract(t.getRawClass().getModifiers())) {
            return true;
        }
        return ((DataObjectInventory)this.m_dataObjectInventory.get()).toTypeName(t.getRawClass()) != null;
    }

    protected static class DataObjectAsPropertyTypeSerializer
    extends AsPropertyTypeSerializer {
        public DataObjectAsPropertyTypeSerializer(TypeIdResolver idRes, String propName) {
            super(idRes, null, propName);
        }

        public WritableTypeId writeTypePrefix(JsonGenerator g, WritableTypeId idMetadata) throws IOException {
            this._generateTypeId(idMetadata);
            if (idMetadata.id != null) {
                return g.writeTypePrefix(idMetadata);
            }
            g.writeStartObject(idMetadata.forValue);
            return idMetadata;
        }
    }
}

