/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.jackson.dataobject;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.jsontype.impl.TypeIdResolverBase;
import com.fasterxml.jackson.databind.type.SimpleType;
import java.util.stream.Collectors;
import org.eclipse.scout.rt.dataobject.DataObjectInventory;
import org.eclipse.scout.rt.platform.Bean;
import org.eclipse.scout.rt.platform.util.LazyValue;

@Bean
public class DataObjectTypeIdResolver
extends TypeIdResolverBase {
    private final LazyValue<DataObjectInventory> m_dataObjectInventory = new LazyValue(DataObjectInventory.class);
    private JavaType m_baseType;

    public void init(JavaType baseType) {
        this.m_baseType = baseType;
    }

    public JsonTypeInfo.Id getMechanism() {
        return JsonTypeInfo.Id.NAME;
    }

    public String idFromValue(Object obj) {
        return this.idFromClass(obj.getClass());
    }

    public String idFromBaseType() {
        return this.idFromClass(this.m_baseType.getRawClass());
    }

    public String idFromValueAndType(Object value, Class<?> clazz) {
        if (value != null) {
            return this.idFromClass(value.getClass());
        }
        return this.idFromClass(clazz);
    }

    protected String idFromClass(Class<?> c) {
        return ((DataObjectInventory)this.m_dataObjectInventory.get()).toTypeName(c);
    }

    public JavaType typeFromId(DatabindContext context, String id) {
        return SimpleType.constructUnsafe((Class)((DataObjectInventory)this.m_dataObjectInventory.get()).fromTypeName(id));
    }

    public String getDescForKnownTypeIds() {
        return ((DataObjectInventory)this.m_dataObjectInventory.get()).getTypeNameToClassMap().entrySet().stream().map(e -> (String)e.getKey() + " -> " + ((Class)e.getValue()).getName()).collect(Collectors.joining("\n"));
    }
}

