/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.jackson.dataobject;

import com.fasterxml.jackson.databind.JavaType;

public class AttributeType {
    private final JavaType m_javaType;
    private final boolean m_doValue;

    public static AttributeType ofDoCollection(JavaType javaType) {
        return new AttributeType(javaType, false);
    }

    public static AttributeType ofDoValue(JavaType javaType) {
        return new AttributeType(javaType, true);
    }

    protected AttributeType(JavaType javaType, boolean doValue) {
        this.m_javaType = javaType;
        this.m_doValue = doValue;
    }

    public JavaType getJavaType() {
        return this.m_javaType;
    }

    public boolean isKnown() {
        return this.m_javaType.getRawClass() != Object.class;
    }

    public boolean isDoCollection() {
        return !this.m_doValue;
    }

    public boolean isDoValue() {
        return this.m_doValue;
    }
}

