/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.dataobject.migration;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.scout.rt.dataobject.IDataObject;
import org.eclipse.scout.rt.dataobject.IDataObjectMapper;
import org.eclipse.scout.rt.dataobject.ILenientDataObjectMapper;
import org.eclipse.scout.rt.dataobject.migration.DataObjectMigrationContext;
import org.eclipse.scout.rt.dataobject.migration.DataObjectMigrationInventory;
import org.eclipse.scout.rt.dataobject.migration.DataObjectMigrationStatsContextData;
import org.eclipse.scout.rt.dataobject.migration.DoStructureMigrationDataObjectVisitor;
import org.eclipse.scout.rt.dataobject.migration.DoStructureMigrationHelper;
import org.eclipse.scout.rt.dataobject.migration.DoValueMigrationDataObjectVisitor;
import org.eclipse.scout.rt.dataobject.migration.DoValueMigrationIdsContextData;
import org.eclipse.scout.rt.dataobject.migration.IDataObjectIntermediateMigration;
import org.eclipse.scout.rt.dataobject.migration.IDataObjectMigrationLocalContextData;
import org.eclipse.scout.rt.dataobject.migration.IDataObjectMigrationLogger;
import org.eclipse.scout.rt.platform.ApplicationScoped;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.namespace.NamespaceVersion;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.CollectionUtility;

@ApplicationScoped
public class DataObjectMigrator {
    public <T extends IDataObject> DataObjectMigratorResult<T> migrateDataObject(DataObjectMigrationContext ctx, String json, Class<T> valueType) {
        Assertions.assertNotNull((Object)json, (String)"json is required", (Object[])new Object[0]);
        return this.migrateDataObject(ctx, new ByteArrayInputStream(json.getBytes(StandardCharsets.UTF_8)), valueType);
    }

    public <T extends IDataObject> DataObjectMigratorResult<T> migrateDataObject(DataObjectMigrationContext ctx, InputStream inputStream, Class<T> valueType) {
        Assertions.assertNotNull((Object)inputStream, (String)"inputStream is required", (Object[])new Object[0]);
        IDataObjectMapper dataObjectMapper = (IDataObjectMapper)BEANS.get(IDataObjectMapper.class);
        IDataObject dataObject = dataObjectMapper.readValueRaw(inputStream);
        return this.migrateDataObject(ctx, dataObject, valueType);
    }

    public <T extends IDataObject> DataObjectMigratorResult<T> migrateDataObject(DataObjectMigrationContext ctx, IDataObject dataObject, Class<T> valueType) {
        Assertions.assertNotNull(valueType, (String)"valueType is required", (Object[])new Object[0]);
        return this.migrateDataObject(ctx, dataObject, valueType, null);
    }

    public <T extends IDataObject> DataObjectMigratorResult<T> migrateDataObject(DataObjectMigrationContext ctx, IDataObject dataObject, Class<T> valueType, IDataObjectMigrationLocalContextData ... initialLocalContextData) {
        return this.migrateDataObject(ctx, dataObject, valueType, null, initialLocalContextData == null ? Collections.emptyList() : Arrays.asList(initialLocalContextData), Collections.emptyList());
    }

    public <T extends IDataObject> DataObjectMigratorResult<T> migrateDataObject(DataObjectMigrationContext ctx, IDataObject dataObject, Class<T> valueType, List<IDataObjectMigrationLocalContextData> initialLocalContextData, List<IDataObjectIntermediateMigration<T>> localIntermediateMigrations) {
        return this.migrateDataObject(ctx, dataObject, valueType, null, initialLocalContextData, localIntermediateMigrations);
    }

    public <T extends IDataObject> DataObjectMigratorResult<T> migrateDataObject(DataObjectMigrationContext ctx, IDataObject dataObject, Class<T> valueType, NamespaceVersion toVersion, List<IDataObjectMigrationLocalContextData> initialLocalContextData, List<IDataObjectIntermediateMigration<T>> localIntermediateMigrations) {
        boolean objectChanged;
        Assertions.assertNotNull((Object)ctx, (String)"ctx is required", (Object[])new Object[0]);
        Assertions.assertNotNull((Object)dataObject, (String)"dataObject is required", (Object[])new Object[0]);
        DataObjectMigrationContext ctxCopy = ctx.copy().withInitialLocalContext(initialLocalContextData);
        DataObjectMigrationStatsContextData stats = ctxCopy.getStats();
        IDataObjectMigrationLogger logger = ctxCopy.getLogger();
        long start = System.nanoTime();
        stats.incrementDataObjectsProcessed();
        logger.trace("Data object before migration: {}", dataObject);
        boolean structureChanged = this.applyStructureMigration(ctxCopy, dataObject, toVersion);
        if (structureChanged) {
            ctx.getLogger().trace("Data object after structure migration: {}", dataObject);
        }
        IDataObjectMapper lenientDataObjectMapper = (IDataObjectMapper)BEANS.get(ILenientDataObjectMapper.class);
        String migratedJson = lenientDataObjectMapper.writeValue(dataObject);
        IDataObject typedDataObject = (IDataObject)lenientDataObjectMapper.readValue(migratedJson, valueType);
        List allIntermediateMigrations = CollectionUtility.combine((Collection[])new Collection[]{ctx.getIntermediateMigrations().all(valueType), localIntermediateMigrations});
        boolean intermediateChanged = false;
        for (IDataObjectIntermediateMigration intermediateMigration : allIntermediateMigrations) {
            DataObjectMigratorResult<IDataObject> result = intermediateMigration.applyMigration(ctx, typedDataObject);
            intermediateChanged |= result.isChanged();
            typedDataObject = result.getDataObject();
        }
        if (intermediateChanged) {
            logger.trace("Data object after intermediate migrations: {}", typedDataObject);
        }
        DataObjectMigratorResult<IDataObject> result = this.applyValueMigration(ctxCopy, typedDataObject);
        boolean valueChanged = result.isChanged();
        IDataObject migratedDataObject = result.getDataObject();
        if (valueChanged) {
            logger.trace("Data object after value migration: {}", migratedDataObject);
        }
        IDataObjectMapper dataObjectMapper = (IDataObjectMapper)BEANS.get(IDataObjectMapper.class);
        String finalJson = dataObjectMapper.writeValue(migratedDataObject);
        migratedDataObject = (IDataObject)dataObjectMapper.readValue(finalJson, valueType);
        boolean bl = objectChanged = structureChanged || intermediateChanged || valueChanged;
        if (objectChanged) {
            stats.incrementDataObjectsChanged();
        }
        stats.addMigrationDuration(start);
        return DataObjectMigratorResult.of(migratedDataObject, objectChanged);
    }

    protected boolean applyStructureMigration(DataObjectMigrationContext ctx, IDataObject dataObject, NamespaceVersion toVersion) {
        Map<String, NamespaceVersion> typeVersions = ((DoStructureMigrationHelper)BEANS.get(DoStructureMigrationHelper.class)).collectRawDataObjectTypeVersions(dataObject);
        if (typeVersions.isEmpty()) {
            ctx.getLogger().debug("No data object entities with a type name found within {}", dataObject);
            return false;
        }
        List<NamespaceVersion> versions = ((DataObjectMigrationInventory)BEANS.get(DataObjectMigrationInventory.class)).getVersions(typeVersions, toVersion);
        if (versions.isEmpty()) {
            return false;
        }
        boolean structureChanged = false;
        for (NamespaceVersion version : versions) {
            DoStructureMigrationDataObjectVisitor visitor = this.createStructureMigrationVisitor(ctx, version);
            visitor.migrate(dataObject);
            structureChanged |= visitor.isChanged();
        }
        ctx.getLogger().debug("Applied structure migrations [{} -> {}] on {}", CollectionUtility.firstElement(versions), CollectionUtility.lastElement(versions), dataObject);
        return structureChanged;
    }

    protected DoStructureMigrationDataObjectVisitor createStructureMigrationVisitor(DataObjectMigrationContext ctx, NamespaceVersion version) {
        return new DoStructureMigrationDataObjectVisitor(ctx, version);
    }

    protected <T extends IDataObject> DataObjectMigratorResult<T> applyValueMigration(DataObjectMigrationContext ctx, T dataObject) {
        if (ctx.getGlobal(DoValueMigrationIdsContextData.class).getAppliedValueMigrationIds() == null) {
            return DataObjectMigratorResult.of(dataObject, false);
        }
        DoValueMigrationDataObjectVisitor valueMigrationVisitor = this.createValueMigrationVisitor(ctx);
        T migratedDataObject = valueMigrationVisitor.migrate(dataObject);
        return DataObjectMigratorResult.of(migratedDataObject, valueMigrationVisitor.isChanged());
    }

    protected DoValueMigrationDataObjectVisitor createValueMigrationVisitor(DataObjectMigrationContext ctx) {
        return new DoValueMigrationDataObjectVisitor(ctx);
    }

    public static final class DataObjectMigratorResult<T extends IDataObject> {
        private T m_dataObject;
        private boolean m_changed;

        private DataObjectMigratorResult(T dataObject, boolean changed) {
            this.m_dataObject = dataObject;
            this.m_changed = changed;
        }

        public static <T extends IDataObject> DataObjectMigratorResult<T> of(T dataObject, boolean changed) {
            return new DataObjectMigratorResult<T>(dataObject, changed);
        }

        public T getDataObject() {
            return this.m_dataObject;
        }

        public boolean isChanged() {
            return this.m_changed;
        }
    }
}

