/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.dataobject.migration;

import java.util.concurrent.atomic.LongAdder;
import org.eclipse.scout.rt.dataobject.migration.DataObjectMigrationPassThroughLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataObjectMigrationCountingPassThroughLogger
extends DataObjectMigrationPassThroughLogger {
    private static final Logger LOG = LoggerFactory.getLogger(DataObjectMigrationCountingPassThroughLogger.class);
    protected final LongAdder m_traceCount = new LongAdder();
    protected final LongAdder m_debugCount = new LongAdder();
    protected final LongAdder m_infoCount = new LongAdder();
    protected final LongAdder m_warnCount = new LongAdder();
    protected final LongAdder m_errorCount = new LongAdder();

    @Override
    public void trace(String message, Object ... args) {
        super.trace(message, args);
        this.m_traceCount.increment();
    }

    @Override
    public void debug(String message, Object ... args) {
        super.debug(message, args);
        this.m_debugCount.increment();
    }

    @Override
    public void info(String message, Object ... args) {
        super.info(message, args);
        this.m_infoCount.increment();
    }

    @Override
    public void warn(String message, Object ... args) {
        super.warn(message, args);
        this.m_warnCount.increment();
    }

    @Override
    public void error(String message, Object ... args) {
        super.error(message, args);
        this.m_errorCount.increment();
    }

    public long getTraceCount() {
        return this.m_traceCount.sum();
    }

    public long getDebugCount() {
        return this.m_debugCount.sum();
    }

    public long getInfoCount() {
        return this.m_infoCount.sum();
    }

    public long getWarnCount() {
        return this.m_warnCount.sum();
    }

    public long getErrorCount() {
        return this.m_errorCount.sum();
    }

    public void printSummary() {
        long total = this.m_traceCount.sum() + this.m_debugCount.sum() + this.m_infoCount.sum() + this.m_warnCount.sum() + this.m_errorCount.sum();
        if (total == 0L) {
            LOG.info("No data object migration log entries were made");
        } else {
            LOG.info("{} data object migration log entries were made: {} trace, {} debug, {} info, {} warn, {} error", new Object[]{total, this.m_traceCount.sum(), this.m_debugCount.sum(), this.m_infoCount.sum(), this.m_warnCount.sum(), this.m_errorCount.sum()});
        }
    }
}

