/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.dataobject.migration;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.scout.rt.dataobject.migration.DataObjectIntermediateMigrationContextData;
import org.eclipse.scout.rt.dataobject.migration.DataObjectMigrationPassThroughLogger;
import org.eclipse.scout.rt.dataobject.migration.DataObjectMigrationStatsContextData;
import org.eclipse.scout.rt.dataobject.migration.IDataObjectMigrationGlobalContextData;
import org.eclipse.scout.rt.dataobject.migration.IDataObjectMigrationLocalContextData;
import org.eclipse.scout.rt.dataobject.migration.IDataObjectMigrationLogger;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.Bean;
import org.eclipse.scout.rt.platform.util.Assertions;

@Bean
public class DataObjectMigrationContext {
    protected final ConcurrentHashMap<Class<? extends IDataObjectMigrationGlobalContextData>, IDataObjectMigrationGlobalContextData> m_globalContextDataMap;
    protected final Map<Class<? extends IDataObjectMigrationLocalContextData>, Deque<IDataObjectMigrationLocalContextData>> m_localContextDataMap;

    public DataObjectMigrationContext() {
        this.m_globalContextDataMap = new ConcurrentHashMap();
        this.m_localContextDataMap = new HashMap<Class<? extends IDataObjectMigrationLocalContextData>, Deque<IDataObjectMigrationLocalContextData>>();
        this.initDefaults();
    }

    protected DataObjectMigrationContext(DataObjectMigrationContext other) {
        this.m_globalContextDataMap = other.m_globalContextDataMap;
        this.m_localContextDataMap = new HashMap<Class<? extends IDataObjectMigrationLocalContextData>, Deque<IDataObjectMigrationLocalContextData>>();
    }

    protected void initDefaults() {
        this.putGlobal((IDataObjectMigrationGlobalContextData)BEANS.get(DataObjectMigrationPassThroughLogger.class));
    }

    protected DataObjectMigrationContext copy() {
        return new DataObjectMigrationContext(this);
    }

    protected DataObjectMigrationContext withInitialLocalContext(List<IDataObjectMigrationLocalContextData> initialLocalContextDatas) {
        if (initialLocalContextDatas != null) {
            initialLocalContextDatas.stream().filter(Objects::nonNull).forEach(this::push);
        }
        return this;
    }

    public <T extends IDataObjectMigrationGlobalContextData> T getGlobal(Class<T> contextDataClass) {
        Assertions.assertNotNull(contextDataClass, (String)"contextDataClass is required", (Object[])new Object[0]);
        IDataObjectMigrationGlobalContextData contextData = this.m_globalContextDataMap.computeIfAbsent(contextDataClass, k -> {
            if (contextDataClass.getAnnotation(Bean.class) != null) {
                return (IDataObjectMigrationGlobalContextData)BEANS.get((Class)contextDataClass);
            }
            return null;
        });
        return (T)((IDataObjectMigrationGlobalContextData)contextDataClass.cast(contextData));
    }

    public DataObjectMigrationContext putGlobal(IDataObjectMigrationGlobalContextData contextData) {
        Assertions.assertNotNull((Object)contextData, (String)"contextData is required", (Object[])new Object[0]);
        this.m_globalContextDataMap.put(contextData.getIdentifierClass(), contextData);
        return this;
    }

    public <T extends IDataObjectMigrationLocalContextData> T get(Class<T> contextDataClass) {
        Assertions.assertNotNull(contextDataClass, (String)"contextDataClass is required", (Object[])new Object[0]);
        Deque<IDataObjectMigrationLocalContextData> deque = this.m_localContextDataMap.get(contextDataClass);
        if (deque == null || deque.isEmpty()) {
            return null;
        }
        return (T)((IDataObjectMigrationLocalContextData)contextDataClass.cast(deque.peek()));
    }

    protected DataObjectMigrationContext push(IDataObjectMigrationLocalContextData contextData) {
        Assertions.assertNotNull((Object)contextData, (String)"contextData is required", (Object[])new Object[0]);
        Deque deque = this.m_localContextDataMap.computeIfAbsent(contextData.getIdentifierClass(), k -> new ArrayDeque());
        deque.push(contextData);
        return this;
    }

    protected void remove(IDataObjectMigrationLocalContextData contextData) {
        Assertions.assertNotNull((Object)contextData, (String)"contextData is required", (Object[])new Object[0]);
        Deque<IDataObjectMigrationLocalContextData> deque = this.m_localContextDataMap.get(contextData.getIdentifierClass());
        Assertions.assertNotNull(deque, (String)"no context data found for {}", (Object[])new Object[]{contextData.getIdentifierClass()});
        IDataObjectMigrationLocalContextData dequeElement = deque.peek();
        Assertions.assertTrue((contextData == dequeElement ? 1 : 0) != 0, (String)"last element in deque is not element to remove: remove '{}', deque: '{}'", (Object[])new Object[]{contextData, dequeElement});
        deque.pop();
        if (deque.isEmpty()) {
            this.m_localContextDataMap.remove(contextData.getIdentifierClass());
        }
    }

    public IDataObjectMigrationLogger getLogger() {
        return this.getGlobal(IDataObjectMigrationLogger.class);
    }

    public DataObjectMigrationStatsContextData getStats() {
        return this.getGlobal(DataObjectMigrationStatsContextData.class);
    }

    public DataObjectIntermediateMigrationContextData getIntermediateMigrations() {
        return this.getGlobal(DataObjectIntermediateMigrationContextData.class);
    }
}

