/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.dataobject.migration;

import org.eclipse.scout.rt.dataobject.DataObjectHelper;
import org.eclipse.scout.rt.dataobject.IDoEntity;
import org.eclipse.scout.rt.dataobject.ITypeVersion;
import org.eclipse.scout.rt.dataobject.migration.AbstractDoValueMigrationHandler;
import org.eclipse.scout.rt.dataobject.migration.DataObjectMigrationContext;
import org.eclipse.scout.rt.platform.BEANS;

public abstract class AbstractRemoveDoEntityContributionValueMigrationHandler<T extends IDoEntity>
extends AbstractDoValueMigrationHandler<T> {
    protected abstract String getContributionTypeName();

    protected abstract Class<? extends ITypeVersion> getContributionTypeVersionClass();

    protected String getContributionTypeVersion() {
        return ((ITypeVersion)BEANS.get(this.getContributionTypeVersionClass())).getVersion().unwrap();
    }

    @Override
    public double primarySortOrder() {
        return 500.0;
    }

    @Override
    public T migrate(DataObjectMigrationContext ctx, T value) {
        if (value.getAllContributions().stream().noneMatch(this::matchesContribution)) {
            return value;
        }
        T clone = ((DataObjectHelper)BEANS.get(DataObjectHelper.class)).cloneLenient(value);
        clone.getAllContributions().removeIf(this::matchesContribution);
        return clone;
    }

    protected boolean matchesContribution(IDoEntity contribution) {
        if (contribution == null) {
            return false;
        }
        return this.getContributionTypeName().equals(contribution.getString("_type")) && this.getContributionTypeVersion().equals(contribution.getString("_typeVersion"));
    }
}

