/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.dataobject.migration;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.scout.rt.dataobject.IDoEntity;
import org.eclipse.scout.rt.dataobject.migration.AbstractDoStructureMigrationHandler;
import org.eclipse.scout.rt.dataobject.migration.DataObjectMigrationContext;
import org.eclipse.scout.rt.dataobject.migration.DoStructureMigrationHelper;
import org.eclipse.scout.rt.platform.BEANS;

public abstract class AbstractDoStructureRenameMigrationHandler
extends AbstractDoStructureMigrationHandler {
    protected final Map<String, String> m_typeNameTranslations = new HashMap<String, String>();
    protected final Map<String, Map<String, String>> m_attributeNameTranslations = new HashMap<String, Map<String, String>>();

    protected AbstractDoStructureRenameMigrationHandler() {
        this.initTypeNameTranslations(this.m_typeNameTranslations);
        this.initAttributeNameTranslations(this.m_attributeNameTranslations);
    }

    protected void initTypeNameTranslations(Map<String, String> typeNameTranslations) {
    }

    protected void initAttributeNameTranslations(Map<String, Map<String, String>> attributeNameTranslations) {
    }

    @Override
    public Set<String> getTypeNames() {
        HashSet<String> typeNames = new HashSet<String>();
        typeNames.addAll(this.m_typeNameTranslations.keySet());
        typeNames.addAll(this.m_attributeNameTranslations.keySet());
        return typeNames;
    }

    @Override
    protected boolean migrate(DataObjectMigrationContext ctx, IDoEntity doEntity) {
        DoStructureMigrationHelper helper = (DoStructureMigrationHelper)BEANS.get(DoStructureMigrationHelper.class);
        boolean changed = false;
        String typeName = helper.getType(doEntity);
        if (this.m_typeNameTranslations.containsKey(typeName)) {
            typeName = this.m_typeNameTranslations.get(typeName);
            helper.setType(doEntity, typeName);
            changed = true;
        }
        if (this.m_attributeNameTranslations.containsKey(typeName)) {
            Map<String, String> attributeTranslations = this.m_attributeNameTranslations.get(typeName);
            for (Map.Entry<String, String> entry : attributeTranslations.entrySet()) {
                String name = entry.getKey();
                String newName = entry.getValue();
                changed |= helper.renameAttribute(doEntity, name, newName);
            }
        }
        return changed;
    }
}

