/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.dataobject.mapping;

import java.util.Objects;
import org.eclipse.scout.rt.dataobject.IDoEntity;
import org.eclipse.scout.rt.dataobject.mapping.IToDoFunction;
import org.eclipse.scout.rt.platform.ApplicationScoped;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.util.Assertions;

@ApplicationScoped
public class ToDoFunctionHelper {
    public <S, T extends IDoEntity> T toDo(S source, Class<? extends IToDoFunction<S, ? extends T>> functionClass) {
        if (source == null) {
            return null;
        }
        Assertions.assertNotNull(functionClass, (String)"functionClass is required", (Object[])new Object[0]);
        return (T)BEANS.all(functionClass).stream().map(f -> (IDoEntity)f.apply(source)).filter(Objects::nonNull).findFirst().orElseThrow(() -> new Assertions.AssertionException("Source {} was not mapped.", new Object[]{source}));
    }
}

