/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.dataobject.mapping;

import org.eclipse.scout.rt.dataobject.IDoEntity;
import org.eclipse.scout.rt.dataobject.mapping.IToDoFunction;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.TypeCastUtility;

public abstract class AbstractToDoFunction<EXPLICIT_SOURCE extends SOURCE, EXPLICIT_TARGET extends TARGET, SOURCE, TARGET extends IDoEntity>
implements IToDoFunction<SOURCE, TARGET> {
    private final Class<EXPLICIT_SOURCE> m_explicitSourceClass = (Class)Assertions.assertNotNull((Object)TypeCastUtility.getGenericsParameterClass(this.getClass(), AbstractToDoFunction.class, (int)0));
    private final Class<EXPLICIT_TARGET> m_explicitTargetClass = (Class)Assertions.assertNotNull((Object)TypeCastUtility.getGenericsParameterClass(this.getClass(), AbstractToDoFunction.class, (int)1));

    protected AbstractToDoFunction() {
    }

    protected Class<EXPLICIT_SOURCE> getExplicitSourceClass() {
        return this.m_explicitSourceClass;
    }

    protected Class<EXPLICIT_TARGET> getExplicitTargetClass() {
        return this.m_explicitTargetClass;
    }

    protected boolean accept(SOURCE source) {
        return this.getExplicitSourceClass().isInstance(source);
    }

    protected EXPLICIT_TARGET createDo() {
        return (EXPLICIT_TARGET)((IDoEntity)BEANS.get(this.getExplicitTargetClass()));
    }

    @Override
    public TARGET apply(SOURCE source) {
        if (!this.accept(source)) {
            return null;
        }
        EXPLICIT_TARGET doEntity = this.createDo();
        if (this.getExplicitSourceClass().isInstance(source)) {
            this.apply(this.getExplicitSourceClass().cast(source), doEntity);
        }
        return (TARGET)doEntity;
    }

    public abstract void apply(EXPLICIT_SOURCE var1, EXPLICIT_TARGET var2);
}

