/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.dataobject.id;

import jakarta.annotation.PostConstruct;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.scout.rt.dataobject.id.IId;
import org.eclipse.scout.rt.dataobject.id.IdSignature;
import org.eclipse.scout.rt.dataobject.id.IdTypeName;
import org.eclipse.scout.rt.platform.ApplicationScoped;
import org.eclipse.scout.rt.platform.CreateImmediately;
import org.eclipse.scout.rt.platform.inventory.ClassInventory;
import org.eclipse.scout.rt.platform.inventory.IClassInfo;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@CreateImmediately
public class IdInventory {
    private static final Logger LOG = LoggerFactory.getLogger(IdInventory.class);
    protected final Map<String, Class<? extends IId>> m_nameToClassMap = new HashMap<String, Class<? extends IId>>();
    protected final Map<Class<? extends IId>, String> m_classToNameMap = new HashMap<Class<? extends IId>, String>();
    protected final Map<Class<? extends IId>, Boolean> m_classToIdSignatureMap = new HashMap<Class<? extends IId>, Boolean>();

    @PostConstruct
    protected void createClassCache() {
        for (IClassInfo classInfo : ClassInventory.get().getKnownAnnotatedTypes(IdTypeName.class)) {
            String typeName = (String)classInfo.getAnnotationValue(IdTypeName.class, "value");
            Assertions.assertNotNullOrEmpty((String)typeName, (String)"Invalid value for @{} on {} (must not be null or empty)", (Object[])new Object[]{IdTypeName.class.getSimpleName(), classInfo.resolveClass().getName()});
            try {
                Class<IId> idClass = classInfo.resolveClass().asSubclass(IId.class);
                this.registerIdTypeName(typeName, idClass);
            }
            catch (ClassCastException e) {
                LOG.warn("Class {} is annotated with @{} but does not implement {}. Skipping class.", new Object[]{classInfo.resolveClass().getName(), IdTypeName.class.getSimpleName(), IId.class.getName()});
            }
        }
        LOG.debug("Registered {} id types", (Object)this.m_nameToClassMap.size());
        for (IClassInfo classInfo : ClassInventory.get().getKnownAnnotatedTypes(IdSignature.class)) {
            Class idClass = classInfo.resolveClass();
            if (IId.class.isAssignableFrom(idClass)) {
                this.registerIdSignature(idClass, idClass.getAnnotation(IdSignature.class).value());
                continue;
            }
            LOG.warn("Class {} is annotated with @{} but does not implement {}. Skipping class.", new Object[]{idClass.getName(), IdSignature.class.getSimpleName(), IId.class.getName()});
        }
        LOG.debug("Registered {} id signature mappings", (Object)this.m_classToIdSignatureMap.size());
    }

    public void registerIdTypeName(String typeName, Class<? extends IId> idClass) {
        Class<? extends IId> registeredIdClass = this.m_nameToClassMap.put(typeName, idClass);
        String registeredTypeName = this.m_classToNameMap.put(idClass, typeName);
        this.checkDuplicateIdTypeNames(idClass, typeName, registeredIdClass, registeredTypeName);
    }

    protected void checkDuplicateIdTypeNames(Class<?> clazz, String typeName, Class<?> existingClass, String existingName) {
        Assertions.assertNull(existingClass, (String)"{} and {} have the same type name '{}'. Use an unique @{} annotation value.", (Object[])new Object[]{clazz, existingClass, typeName, IdTypeName.class.getSimpleName()});
        Assertions.assertNull((Object)existingName, (String)"{} is annotated with @{} value '{}', but was already registered with type name '{}'. Register each class only once.", (Object[])new Object[]{clazz, IdTypeName.class.getSimpleName(), typeName, existingName});
    }

    public void registerIdSignature(Class<? extends IId> idClass, boolean signature) {
        this.m_classToIdSignatureMap.put(idClass, signature);
    }

    public String getTypeName(Class<? extends IId> idClass) {
        return this.m_classToNameMap.get(idClass);
    }

    public String getTypeName(IId id) {
        if (id == null) {
            return null;
        }
        return this.getTypeName(id.getClass());
    }

    public Class<? extends IId> getIdClass(String typeName) {
        return this.m_nameToClassMap.get(typeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isIdSignature(Class<? extends IId> idClass) {
        Map<Class<? extends IId>, Boolean> map = this.m_classToIdSignatureMap;
        synchronized (map) {
            if (this.m_classToIdSignatureMap.containsKey(idClass)) {
                return this.m_classToIdSignatureMap.get(idClass);
            }
            IdSignature idSignature = idClass.getAnnotation(IdSignature.class);
            boolean signature = idSignature != null ? idSignature.value() : (idClass.getSuperclass() != null && IId.class.isAssignableFrom(idClass.getSuperclass()) ? this.isIdSignature(idClass.getSuperclass()) : IId.class.getAnnotation(IdSignature.class).value());
            this.m_classToIdSignatureMap.put(idClass, signature);
            return this.m_classToIdSignatureMap.get(idClass);
        }
    }
}

