/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.dataobject.id;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.scout.rt.dataobject.id.AbstractRootId;
import org.eclipse.scout.rt.dataobject.id.IId;
import org.eclipse.scout.rt.dataobject.id.RawTypes;
import org.eclipse.scout.rt.platform.ApplicationScoped;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.exception.PlatformException;
import org.eclipse.scout.rt.platform.exception.PlatformExceptionTranslator;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.TypeCastUtility;

@ApplicationScoped
public class IdFactory {
    protected final ConcurrentMap<Class<? extends IId>, Method> m_ofMethodsByIdType = new ConcurrentHashMap<Class<? extends IId>, Method>();
    protected final ConcurrentMap<Class<? extends IId>, List<Class<?>>> m_rawTypesByIdType = new ConcurrentHashMap();

    public <ID extends IId> ID createInternal(Class<ID> idClass, Object ... values) {
        try {
            Method createMethod = this.lookupCreateMethod(idClass);
            return (ID)((IId)idClass.cast(createMethod.invoke(null, values)));
        }
        catch (Exception e) {
            throw ((PlatformExceptionTranslator)BEANS.get(PlatformExceptionTranslator.class)).translate((Throwable)e).withContextInfo("idClass", (Object)idClass.getName(), new Object[0]).withContextInfo("values", (Object)Arrays.toString(values), new Object[0]);
        }
    }

    public <ID extends IId> List<Class<?>> getRawTypes(Class<ID> idClass) {
        return this.m_rawTypesByIdType.computeIfAbsent(idClass, this::findTypeParameters);
    }

    public List<Class<?>> findTypeParameters(Class<? extends IId> idClass) {
        return List.of(this.lookupCreateMethod(idClass).getParameterTypes());
    }

    protected <ID extends IId> Method lookupCreateMethod(Class<ID> idClass) {
        return this.m_ofMethodsByIdType.computeIfAbsent(idClass, this::findOfByTypesMethod);
    }

    protected Method findOfByTypesMethod(Class<? extends IId> idClass) {
        Method[] methodArray = idClass.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            if (m.getAnnotation(RawTypes.class) != null && "of".equals(m.getName())) {
                Assertions.assertTrue((boolean)Modifier.isStatic(m.getModifiers()), (String)"method 'of({})' is expected to be static [method={}]", (Object[])new Object[]{Arrays.toString(m.getParameterTypes()), m});
                return m;
            }
            ++n2;
        }
        if (AbstractRootId.class.isAssignableFrom(idClass)) {
            Class parameterType = TypeCastUtility.getGenericsParameterClass(idClass, AbstractRootId.class);
            return this.findOfMethod(idClass, parameterType);
        }
        throw new PlatformException("Cannot find a static method 'of({})' on id class {}.", new Object[]{idClass.getName(), idClass});
    }

    protected Method findOfMethod(Class<? extends IId> idClass, Class<?> ... parameterTypes) {
        try {
            Method m = idClass.getMethod("of", parameterTypes);
            Assertions.assertTrue((boolean)Modifier.isStatic(m.getModifiers()), (String)"method 'of({})' is expected to be static [method={}]", (Object[])new Object[]{Arrays.toString(parameterTypes), m});
            return m;
        }
        catch (NoSuchMethodException e) {
            throw new PlatformException("Cannot find a static method 'of({})' on id class {}.", new Object[]{Arrays.toString(parameterTypes), idClass.getName()});
        }
    }
}

