/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.dataobject.id;

import jakarta.annotation.PostConstruct;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.scout.rt.dataobject.id.ICompositeId;
import org.eclipse.scout.rt.dataobject.id.IId;
import org.eclipse.scout.rt.dataobject.id.IRootId;
import org.eclipse.scout.rt.dataobject.id.IdCodecException;
import org.eclipse.scout.rt.dataobject.id.IdFactory;
import org.eclipse.scout.rt.dataobject.id.IdInventory;
import org.eclipse.scout.rt.dataobject.id.IdTypeName;
import org.eclipse.scout.rt.dataobject.id.UnknownId;
import org.eclipse.scout.rt.platform.ApplicationScoped;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.config.AbstractStringConfigProperty;
import org.eclipse.scout.rt.platform.config.CONFIG;
import org.eclipse.scout.rt.platform.security.SecurityUtility;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.Base64Utility;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.LazyValue;
import org.eclipse.scout.rt.platform.util.ObjectUtility;
import org.eclipse.scout.rt.platform.util.StringUtility;

@ApplicationScoped
public class IdCodec {
    protected static final String ID_TYPENAME_DELIMITER = ":";
    protected static final String SIGNATURE_DELIMITER = "_-~SIG~-_";
    protected static final String COMPOSITE_ID_DELIMITER = ";";
    protected final LazyValue<IdFactory> m_idFactory = new LazyValue(IdFactory.class);
    protected final LazyValue<IdInventory> m_idInventory = new LazyValue(IdInventory.class);
    protected final Map<Class<?>, Function<String, Object>> m_rawTypeFromStringMapper = new HashMap();
    protected final Map<Class<?>, Function<Object, String>> m_rawTypeToStringMapper = new HashMap();

    @PostConstruct
    protected void initialize() {
        this.registerRawTypeMapper(String.class, s -> s, Object::toString);
        this.registerRawTypeMapper(UUID.class, UUID::fromString, Object::toString);
        this.registerRawTypeMapper(Long.class, Long::parseLong, Object::toString);
        this.registerRawTypeMapper(Integer.class, Integer::parseInt, Object::toString);
        this.registerRawTypeMapper(Date.class, d -> new Date(Long.parseLong(d)), d -> String.valueOf(d.getTime()));
        this.registerRawTypeMapper(Locale.class, Locale::forLanguageTag, Locale::toLanguageTag);
        this.registerRawTypeMapper(Boolean.class, Boolean::valueOf, Object::toString);
    }

    protected IdFactory idFactory() {
        return (IdFactory)this.m_idFactory.get();
    }

    protected IdInventory idInventory() {
        return (IdInventory)this.m_idInventory.get();
    }

    public String toQualified(IId id, IIdCodecFlag ... flags) {
        return this.toQualified(id, CollectionUtility.hashSet((Object[])flags));
    }

    public String toQualified(IId id, Set<IIdCodecFlag> flags) {
        if (id == null) {
            return null;
        }
        String typeName = this.idInventory().getTypeName(id);
        if (StringUtility.isNullOrEmpty((CharSequence)typeName)) {
            if (id instanceof UnknownId) {
                return StringUtility.join((String)ID_TYPENAME_DELIMITER, (Object[])new Object[]{((UnknownId)id).getIdTypeName(), this.toUnqualified(id, flags)});
            }
            throw new IdCodecException("Missing @{} in class {}", IdTypeName.class.getSimpleName(), id.getClass());
        }
        return typeName + ID_TYPENAME_DELIMITER + this.toUnqualified(id, flags);
    }

    public String toUnqualified(IId id, IIdCodecFlag ... flags) {
        return this.toUnqualified(id, CollectionUtility.hashSet((Object[])flags));
    }

    public String toUnqualified(IId id, Set<IIdCodecFlag> flags) {
        if (id == null) {
            return null;
        }
        if (id instanceof IRootId) {
            Object value = id.unwrap();
            Function<Object, String> mapper = this.m_rawTypeToStringMapper.get(value.getClass());
            if (mapper == null) {
                throw new IdCodecException("Missing raw type mapper for wrapped type {}, id type {}", value.getClass(), id.getClass());
            }
            return this.addSignature(id.getClass(), mapper.apply(value), flags);
        }
        if (id instanceof ICompositeId) {
            Object compositeParts = ((ICompositeId)id).unwrap();
            Set flagsWithoutSignature = flags.stream().filter(Predicate.not(IdCodecFlag.SIGNATURE::equals)).collect(Collectors.toSet());
            return this.addSignature(id.getClass(), compositeParts.stream().map(compositePart -> this.toUnqualifiedCompositePart((IId)compositePart, flagsWithoutSignature)).map(s -> s == null ? "" : s).collect(Collectors.joining(COMPOSITE_ID_DELIMITER)), flags);
        }
        if (id instanceof UnknownId) {
            return this.addSignature(UnknownId.class, ((UnknownId)id).getId(), flags);
        }
        return this.addSignature(id.getClass(), this.handleToUnqualifiedUnknownIdType(id, flags), flags);
    }

    protected String toUnqualifiedCompositePart(IId compositePart, Set<IIdCodecFlag> flags) {
        return this.toUnqualified(compositePart, flags);
    }

    protected String addSignature(Class<? extends IId> idClass, String unqualifiedId, Set<IIdCodecFlag> flags) {
        if (StringUtility.isNullOrEmpty((CharSequence)unqualifiedId) || !ObjectUtility.isOneOf((Object)IdCodecFlag.SIGNATURE, flags) || !this.idInventory().isIdSignature(idClass)) {
            return unqualifiedId;
        }
        return unqualifiedId + SIGNATURE_DELIMITER + this.createSignature(unqualifiedId);
    }

    public String createSignature(String unqualifiedId) {
        if (StringUtility.isNullOrEmpty((CharSequence)unqualifiedId)) {
            return "";
        }
        return Base64Utility.encodeUrlSafe((byte[])SecurityUtility.createMac((byte[])this.getIdSignaturePassword(), (byte[])unqualifiedId.getBytes(StandardCharsets.UTF_8)));
    }

    protected byte[] getIdSignaturePassword() {
        String password = (String)CONFIG.getPropertyValue(IdSignaturePasswordProperty.class);
        if (password == null) {
            throw new IdCodecException("Password property {} not set.", ((IdSignaturePasswordProperty)((Object)BEANS.get(IdSignaturePasswordProperty.class))).getKey());
        }
        return password.getBytes(StandardCharsets.UTF_8);
    }

    public IId fromQualified(String qualifiedId, IIdCodecFlag ... flags) {
        return this.fromQualified(qualifiedId, CollectionUtility.hashSet((Object[])flags));
    }

    public IId fromQualified(String qualifiedId, Set<IIdCodecFlag> flags) {
        return this.fromQualifiedInternal(qualifiedId, flags);
    }

    public <ID extends IId> ID fromUnqualified(Class<ID> idClass, String unqualifiedId, IIdCodecFlag ... flags) {
        return this.fromUnqualified(idClass, unqualifiedId, CollectionUtility.hashSet((Object[])flags));
    }

    public <ID extends IId> ID fromUnqualified(Class<ID> idClass, String unqualifiedId, Set<IIdCodecFlag> flags) {
        if (idClass == null) {
            throw new IdCodecException("Missing id class to parse unqualified id {}", unqualifiedId);
        }
        if (StringUtility.isNullOrEmpty((CharSequence)unqualifiedId)) {
            return null;
        }
        return this.fromUnqualifiedUnchecked(idClass, unqualifiedId, flags);
    }

    public <T> void registerRawTypeMapper(Class<T> rawType, Function<String, Object> fromStringMapper, Function<T, String> toStringMapper) {
        Assertions.assertNotNull(rawType, (String)"cannot register type mapper for null type", (Object[])new Object[0]);
        Assertions.assertNotNull(fromStringMapper, (String)"cannot register null type mapper from string", (Object[])new Object[0]);
        Assertions.assertNotNull(toStringMapper, (String)"cannot register null type mapper to string", (Object[])new Object[0]);
        this.m_rawTypeToStringMapper.put(rawType, toStringMapper);
        this.m_rawTypeFromStringMapper.put(rawType, fromStringMapper);
    }

    public void unregisterRawTypeMapper(Class<?> rawType) {
        this.m_rawTypeToStringMapper.remove(rawType);
        this.m_rawTypeFromStringMapper.remove(rawType);
    }

    protected String handleToUnqualifiedUnknownIdType(IId id, Set<IIdCodecFlag> flags) {
        throw new IdCodecException("Unsupported id type {}, cannot convert id {}", id.getClass(), id);
    }

    protected IId fromQualifiedInternal(String qualifiedId, Set<IIdCodecFlag> flags) {
        if (StringUtility.isNullOrEmpty((CharSequence)qualifiedId)) {
            return null;
        }
        boolean lenient = ObjectUtility.isOneOf((Object)IdCodecFlag.LENIENT, flags);
        String[] tmp = qualifiedId.split(ID_TYPENAME_DELIMITER, 2);
        if (tmp.length < 2) {
            if (lenient) {
                return UnknownId.of(null, qualifiedId);
            }
            throw new IdCodecException("Qualified id '{}' format is invalid", qualifiedId);
        }
        String typeName = tmp[0];
        Class<? extends IId> idClass = this.idInventory().getIdClass(typeName);
        if (idClass == null) {
            if (lenient) {
                return UnknownId.of(typeName, tmp[1]);
            }
            throw new IdCodecException("No class found for type name '{}'", typeName);
        }
        try {
            return this.fromUnqualified(idClass, tmp[1], flags);
        }
        catch (Exception e) {
            if (lenient) {
                return UnknownId.of(typeName, tmp[1]);
            }
            throw e;
        }
    }

    protected <ID extends IId> ID fromUnqualifiedUnchecked(Class<ID> idClass, String unqualifiedId, Set<IIdCodecFlag> flags) {
        unqualifiedId = this.removeSignature(idClass, unqualifiedId, flags);
        String[] rawComponents = unqualifiedId.split(COMPOSITE_ID_DELIMITER, -1);
        Object[] components = this.parseComponents(idClass, rawComponents, flags);
        return this.idFactory().createInternal(idClass, components);
    }

    public String removeSignature(Class<? extends IId> idClass, String unqualifiedId, Set<IIdCodecFlag> flags) {
        String[] unqualifiedIdSignatureParts = this.splitToSignatureParts(unqualifiedId);
        this.assertSignature(idClass, unqualifiedId, unqualifiedIdSignatureParts, flags);
        return unqualifiedIdSignatureParts[0];
    }

    protected void assertSignature(Class<? extends IId> idClass, String unqualifiedId, String[] unqualifiedIdSignatureParts, Set<IIdCodecFlag> flags) {
        if (!ObjectUtility.isOneOf((Object)IdCodecFlag.SIGNATURE, flags) || !this.idInventory().isIdSignature(idClass)) {
            this.checkEquals(unqualifiedIdSignatureParts.length, 1, "Unqualified id must not be signed.");
            this.checkEquals(unqualifiedIdSignatureParts[0], unqualifiedId, "Unqualified id must not be signed.");
            return;
        }
        this.checkEquals(unqualifiedIdSignatureParts.length, 2, "Unqualified id must be signed.");
        this.checkEquals(unqualifiedIdSignatureParts[1], this.createSignature(unqualifiedIdSignatureParts[0]), "Signature of unqualified id does not match.");
    }

    protected void checkEquals(Object o1, Object o2, String message) {
        if (!Objects.equals(o1, o2)) {
            throw new IdCodecException(message, new Object[0]);
        }
    }

    protected String[] splitToSignatureParts(String unqualifiedId) {
        int i = unqualifiedId.lastIndexOf(SIGNATURE_DELIMITER);
        if (i < 0) {
            return new String[]{unqualifiedId};
        }
        if (i + SIGNATURE_DELIMITER.length() == unqualifiedId.length()) {
            return new String[]{unqualifiedId.substring(0, i)};
        }
        return new String[]{unqualifiedId.substring(0, i), unqualifiedId.substring(i + SIGNATURE_DELIMITER.length())};
    }

    protected Object[] parseComponents(Class<? extends IId> idClass, String[] rawComponents, Set<IIdCodecFlag> flags) {
        List<Class<?>> componentTypes = this.idFactory().getRawTypes(idClass);
        if (componentTypes.size() != rawComponents.length) {
            throw new IdCodecException("Wrong argument size, expected {} parameter, got {} raw components {}, idType={}", componentTypes.size(), rawComponents.length, Arrays.toString(rawComponents), idClass.getName());
        }
        Object[] components = new Object[rawComponents.length];
        int i = 0;
        while (i < rawComponents.length) {
            Class<?> type = componentTypes.get(i);
            Function<String, Object> mapper = this.m_rawTypeFromStringMapper.get(type);
            if (mapper == null) {
                throw new IdCodecException("Missing raw type mapper for wrapped type {}, id type {}", type, idClass);
            }
            try {
                String raw = rawComponents[i];
                components[i] = StringUtility.isNullOrEmpty((CharSequence)raw) ? null : mapper.apply(raw);
            }
            catch (Exception e) {
                throw new IdCodecException("Failed to parse component value={}, rawType={}, idType={}", rawComponents[i], type.getName(), idClass.getName(), e);
            }
            ++i;
        }
        return components;
    }

    public static interface IIdCodecFlag {
    }

    public static enum IdCodecFlag implements IIdCodecFlag
    {
        LENIENT,
        SIGNATURE;

    }

    public static class IdSignaturePasswordProperty
    extends AbstractStringConfigProperty {
        public String getKey() {
            return "scout.idSignaturePassword";
        }

        public String description() {
            return "Password to create signatures for ids that are serialized or deserialized. The value of this password must be equal for all parts of an application.";
        }
    }
}

