/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.dataobject.id;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.scout.rt.dataobject.id.ICompositeId;
import org.eclipse.scout.rt.dataobject.id.IId;
import org.eclipse.scout.rt.dataobject.id.IdSignature;

@IdSignature
public abstract class AbstractCompositeId
implements ICompositeId {
    private static final long serialVersionUID = 1L;
    private final List<? extends IId> m_idComponents;

    protected AbstractCompositeId(IId ... idComponents) {
        if (idComponents == null || idComponents.length == 0) {
            throw new IllegalArgumentException("idComponents is null");
        }
        this.m_idComponents = Arrays.asList(idComponents);
    }

    @Override
    public List<? extends IId> unwrap() {
        return Collections.unmodifiableList(this.m_idComponents);
    }

    protected final <ID extends IId> ID idComponent(int index) {
        return (ID)this.m_idComponents.get(index);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractCompositeId compositeId = (AbstractCompositeId)o;
        return this.m_idComponents.equals(compositeId.m_idComponents);
    }

    public int hashCode() {
        return this.m_idComponents.hashCode();
    }

    public String toString() {
        return this.getClass().getSimpleName() + String.valueOf(this.m_idComponents);
    }
}

