/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.dataobject.enumeration;

import jakarta.annotation.PostConstruct;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.scout.rt.dataobject.enumeration.EnumName;
import org.eclipse.scout.rt.dataobject.enumeration.IEnum;
import org.eclipse.scout.rt.platform.ApplicationScoped;
import org.eclipse.scout.rt.platform.inventory.ClassInventory;
import org.eclipse.scout.rt.platform.inventory.IClassInfo;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class EnumInventory {
    private static final Logger LOG = LoggerFactory.getLogger(EnumInventory.class);
    private final Map<String, Class<? extends IEnum>> m_enumNameToClassMap = new HashMap<String, Class<? extends IEnum>>();
    private final Map<Class<? extends IEnum>, String> m_classToEnumName = new HashMap<Class<? extends IEnum>, String>();

    @PostConstruct
    protected void init() {
        ClassInventory.get().getKnownAnnotatedTypes(EnumName.class).stream().map(IClassInfo::resolveClass).forEach(this::registerClass);
        LOG.info("Registry initialized, found {} {} implementations with @{} annotation.", new Object[]{this.m_enumNameToClassMap.size(), IEnum.class.getSimpleName(), EnumName.class.getSimpleName()});
    }

    public String toEnumName(Class<?> queryClazz) {
        return this.m_classToEnumName.get(queryClazz);
    }

    public Class<? extends IEnum> fromEnumName(String enumName) {
        return this.m_enumNameToClassMap.get(enumName);
    }

    public Map<String, Class<? extends IEnum>> getEnumNameToClassMap() {
        return Collections.unmodifiableMap(this.m_enumNameToClassMap);
    }

    protected void registerClass(Class<?> clazz) {
        if (IEnum.class.isAssignableFrom(clazz)) {
            Class<IEnum> entityClass = clazz.asSubclass(IEnum.class);
            String name = this.resolveEnumName(clazz);
            if (StringUtility.hasText((CharSequence)name)) {
                String registeredName = this.m_classToEnumName.put(entityClass, name);
                Class<IEnum> registeredClass = this.m_enumNameToClassMap.put(name, entityClass);
                this.checkDuplicateClassMapping(clazz, name, registeredName, registeredClass);
                LOG.debug("Registered class {} with enum name '{}'", entityClass, (Object)name);
            } else {
                LOG.warn("Class {} is annotated with @{} with an empty enum name value, skip registration", (Object)clazz.getName(), (Object)EnumName.class.getSimpleName());
            }
        } else {
            LOG.warn("Class {} is annotated with @{} but is not an instance of {}, skip registration", new Object[]{clazz.getName(), EnumName.class.getSimpleName(), IEnum.class});
        }
    }

    protected void checkDuplicateClassMapping(Class<?> clazz, String name, String existingName, Class<? extends IEnum> existingClass) {
        Assertions.assertNull(existingClass, (String)"{} and {} have the same type '{}', use an unique @{} annotation value.", (Object[])new Object[]{clazz, existingClass, name, EnumName.class.getSimpleName()});
        Assertions.assertNull((Object)existingName, (String)"{} was already registered with enum name {}, register each class only once.", (Object[])new Object[]{clazz, existingName, EnumName.class.getSimpleName()});
    }

    protected String resolveEnumName(Class<?> c) {
        EnumName enumNameAnn = c.getAnnotation(EnumName.class);
        return enumNameAnn == null ? null : enumNameAnn.value();
    }
}

