/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.dataobject;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.scout.rt.dataobject.DoList;
import org.eclipse.scout.rt.dataobject.DoNode;
import org.eclipse.scout.rt.dataobject.IDataObject;
import org.eclipse.scout.rt.dataobject.IDoEntityContribution;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.Bean;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.TypeCastUtility;

@Bean
public interface IDoEntity
extends IDataObject {
    public DoNode<?> getNode(String var1);

    public Map<String, DoNode<?>> allNodes();

    default public void putNode(String attributeName, DoNode<?> attribute) {
        Assertions.assertNotNull((Object)attributeName, (String)"attribute name cannot be null", (Object[])new Object[0]);
        Assertions.assertNotNull(attribute, (String)"attribute node cannot be null for attribute name {}", (Object[])new Object[]{attributeName});
        attribute.setAttributeName(attributeName);
    }

    default public <V> void putIf(String attributeName, V value, Predicate<V> predicate) {
        if (predicate.test(value)) {
            this.put(attributeName, value);
        }
    }

    default public <V> void putListIf(String attributeName, List<V> value, Predicate<? super List<V>> predicate) {
        if (predicate.test(value)) {
            this.putList(attributeName, value);
        }
    }

    default public <V> void putSetIf(String attributeName, Set<V> value, Predicate<? super Set<V>> predicate) {
        if (predicate.test(value)) {
            this.putSet(attributeName, value);
        }
    }

    default public <V> void putCollectionIf(String attributeName, Collection<V> value, Predicate<? super Collection<V>> predicate) {
        if (predicate.test(value)) {
            this.putCollection(attributeName, value);
        }
    }

    public boolean has(String var1);

    public void put(String var1, Object var2);

    public <V> void putList(String var1, List<V> var2);

    public <V> void putSet(String var1, Set<V> var2);

    public <V> void putCollection(String var1, Collection<V> var2);

    public boolean remove(String var1);

    public boolean removeIf(Predicate<? super DoNode<?>> var1);

    public Map<String, ?> all();

    default public Optional<DoNode<?>> optNode(String attributeName) {
        return Optional.ofNullable(this.getNode(attributeName));
    }

    default public Object get(String attributeName) {
        DoNode<?> node = this.getNode(attributeName);
        if (node != null) {
            return node.get();
        }
        return null;
    }

    default public <T> T get(String attributeName, Class<T> type) {
        Assertions.assertNotNull(type, (String)"provided type is null", (Object[])new Object[0]);
        return type.cast(this.get(attributeName));
    }

    default public <T> T get(String attributeName, Function<Object, T> mapper) {
        Assertions.assertNotNull(mapper, (String)"provided mapper function is null", (Object[])new Object[0]);
        return mapper.apply(this.get(attributeName));
    }

    default public List<Object> getList(String attributeName) {
        return this.getList(attributeName, Object.class);
    }

    default public <T> List<T> getList(String attributeName, Class<T> type) {
        if (!this.has(attributeName)) {
            this.putList(attributeName, null);
        }
        return (List)((DoList)Assertions.assertType(this.getNode(attributeName), DoList.class)).get();
    }

    default public <T> List<T> getList(String attributeName, Function<Object, T> mapper) {
        Assertions.assertNotNull(mapper, (String)"provided mapper function is null", (Object[])new Object[0]);
        return this.getList(attributeName).stream().map(mapper).collect(Collectors.toList());
    }

    default public Optional<List<Object>> optList(String attributeName) {
        return this.optList(attributeName, Object.class);
    }

    default public <T> Optional<List<T>> optList(String attributeName, Class<T> type) {
        return this.optNode(attributeName).map(n -> (List)((DoList)Assertions.assertType((Object)n, DoList.class)).get());
    }

    default public BigDecimal getDecimal(String attributeName) {
        return (BigDecimal)TypeCastUtility.castValue((Object)Assertions.assertType((Object)this.get(attributeName), Number.class), BigDecimal.class);
    }

    default public List<BigDecimal> getDecimalList(String attributeName) {
        return this.getList(attributeName, (Object item) -> (BigDecimal)TypeCastUtility.castValue((Object)Assertions.assertType((Object)item, Number.class), BigDecimal.class));
    }

    default public Boolean getBoolean(String attributeName) {
        return (Boolean)Assertions.assertType((Object)this.get(attributeName), Boolean.class);
    }

    default public List<Boolean> getBooleanList(String attributeName) {
        return this.getList(attributeName, (Object item) -> (Boolean)Assertions.assertType((Object)item, Boolean.class));
    }

    default public String getString(String attributeName) {
        return (String)Assertions.assertType((Object)this.get(attributeName), String.class);
    }

    default public List<String> getStringList(String attributeName) {
        return this.getList(attributeName, (Object item) -> (String)Assertions.assertType((Object)item, String.class));
    }

    default public boolean remove(Supplier<? extends DoNode<?>> nodeAccessor) {
        return this.remove(nodeAccessor.get());
    }

    default public boolean remove(DoNode<?> node) {
        return this.remove(node.getAttributeName());
    }

    default public boolean isEmpty() {
        return this.allNodes().isEmpty();
    }

    public boolean hasContributions();

    public Collection<IDoEntityContribution> getContributions();

    @Deprecated
    public Collection<IDoEntity> getAllContributions();

    default public <CONTRIBUTION extends IDoEntityContribution> CONTRIBUTION contribution(Class<CONTRIBUTION> contributionClass) {
        if (!this.hasContribution(contributionClass)) {
            IDoEntityContribution contribution = (IDoEntityContribution)BEANS.get(contributionClass);
            this.putContribution(contribution);
            return (CONTRIBUTION)contribution;
        }
        return this.getContribution(contributionClass);
    }

    default public <CONTRIBUTION extends IDoEntityContribution> CONTRIBUTION getContribution(Class<CONTRIBUTION> contributionClass) {
        Assertions.assertNotNull(contributionClass, (String)"contributionClass is required", (Object[])new Object[0]);
        if (!this.hasContributions()) {
            return null;
        }
        return (CONTRIBUTION)((IDoEntityContribution)this.getContributions().stream().filter(contribution -> contributionClass.equals(contribution.getClass())).findFirst().map(contributionClass::cast).orElse(null));
    }

    default public boolean hasContribution(Class<? extends IDoEntityContribution> contributionClass) {
        return this.getContribution(contributionClass) != null;
    }

    default public void putContribution(IDoEntityContribution contribution) {
        Assertions.assertNotNull((Object)contribution, (String)"contribution is required", (Object[])new Object[0]);
        this.removeContribution(contribution.getClass());
        this.getAllContributions().add(contribution);
    }

    default public boolean removeContribution(Class<? extends IDoEntityContribution> contributionClass) {
        if (!this.hasContributions()) {
            return false;
        }
        return this.getAllContributions().removeIf((? super E contribution) -> contributionClass.equals(contribution.getClass()));
    }
}

