/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.dataobject;

import java.util.Collection;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import org.eclipse.scout.rt.dataobject.DoValue;
import org.eclipse.scout.rt.dataobject.IDoCollection;
import org.eclipse.scout.rt.platform.util.Assertions;

public final class DoPredicates {
    private DoPredicates() {
    }

    public static <VALUE, DO_ENTITY> Predicate<DO_ENTITY> exists(Function<DO_ENTITY, DoValue<VALUE>> accessor) {
        Assertions.assertNotNull(accessor, (String)"accessor is required", (Object[])new Object[0]);
        return e -> ((DoValue)accessor.apply(e)).exists();
    }

    public static <VALUE, DO_ENTITY> Predicate<DO_ENTITY> notExists(Function<DO_ENTITY, DoValue<VALUE>> accessor) {
        return DoPredicates.exists(accessor).negate();
    }

    public static <VALUE, DO_ENTITY> Predicate<DO_ENTITY> isNull(Function<DO_ENTITY, DoValue<VALUE>> accessor) {
        Assertions.assertNotNull(accessor, (String)"accessor is required", (Object[])new Object[0]);
        return e -> ((DoValue)accessor.apply(e)).get() == null;
    }

    public static <VALUE, DO_ENTITY> Predicate<DO_ENTITY> isNotNull(Function<DO_ENTITY, DoValue<VALUE>> accessor) {
        return DoPredicates.isNull(accessor).negate();
    }

    public static <VALUE, DO_ENTITY> Predicate<DO_ENTITY> eq(Function<DO_ENTITY, DoValue<VALUE>> accessor, VALUE value) {
        Assertions.assertNotNull(accessor, (String)"accessor must not be null", (Object[])new Object[0]);
        return e -> Objects.equals(((DoValue)accessor.apply(e)).get(), value);
    }

    public static <VALUE, DO_ENTITY> Predicate<DO_ENTITY> ne(Function<DO_ENTITY, DoValue<VALUE>> accessor, VALUE value) {
        return DoPredicates.eq(accessor, value).negate();
    }

    public static <VALUE extends Comparable<VALUE>, DO_ENTITY> Predicate<DO_ENTITY> le(Function<DO_ENTITY, DoValue<VALUE>> accessor, VALUE value) {
        Assertions.assertNotNull(accessor, (String)"accessor is required", (Object[])new Object[0]);
        Assertions.assertNotNull(value, (String)"value is required", (Object[])new Object[0]);
        return e -> {
            DoValue doValue = (DoValue)accessor.apply(e);
            return doValue.get() != null && ((Comparable)doValue.get()).compareTo(value) <= 0;
        };
    }

    public static <VALUE extends Comparable<VALUE>, DO_ENTITY> Predicate<DO_ENTITY> lt(Function<DO_ENTITY, DoValue<VALUE>> accessor, VALUE value) {
        Assertions.assertNotNull(accessor, (String)"accessor is required", (Object[])new Object[0]);
        Assertions.assertNotNull(value, (String)"value is required", (Object[])new Object[0]);
        return e -> {
            DoValue doValue = (DoValue)accessor.apply(e);
            return doValue.get() != null && ((Comparable)doValue.get()).compareTo(value) < 0;
        };
    }

    public static <VALUE extends Comparable<VALUE>, DO_ENTITY> Predicate<DO_ENTITY> ge(Function<DO_ENTITY, DoValue<VALUE>> accessor, VALUE value) {
        Assertions.assertNotNull(accessor, (String)"accessor is required", (Object[])new Object[0]);
        Assertions.assertNotNull(value, (String)"value is required", (Object[])new Object[0]);
        return e -> {
            DoValue doValue = (DoValue)accessor.apply(e);
            return doValue.get() != null && ((Comparable)doValue.get()).compareTo(value) >= 0;
        };
    }

    public static <VALUE extends Comparable<VALUE>, DO_ENTITY> Predicate<DO_ENTITY> gt(Function<DO_ENTITY, DoValue<VALUE>> accessor, VALUE value) {
        Assertions.assertNotNull(accessor, (String)"accessor is required", (Object[])new Object[0]);
        Assertions.assertNotNull(value, (String)"value is required", (Object[])new Object[0]);
        return e -> {
            DoValue doValue = (DoValue)accessor.apply(e);
            return doValue.get() != null && ((Comparable)doValue.get()).compareTo(value) > 0;
        };
    }

    public static <VALUE, DO_ENTITY> Predicate<DO_ENTITY> in(Function<DO_ENTITY, DoValue<VALUE>> accessor, Collection<VALUE> values) {
        Assertions.assertNotNull(accessor, (String)"accessor must not be null", (Object[])new Object[0]);
        Assertions.assertNotNull(values, (String)"values must not be null", (Object[])new Object[0]);
        return e -> values.contains(((DoValue)accessor.apply(e)).get());
    }

    public static <VALUE, DO_ENTITY> Predicate<DO_ENTITY> notIn(Function<DO_ENTITY, DoValue<VALUE>> accessor, Collection<VALUE> values) {
        return DoPredicates.in(accessor, values).negate();
    }

    public static <DO_ENTITY, COLLECTION_ITEM> Predicate<DO_ENTITY> exists(Function<DO_ENTITY, IDoCollection<COLLECTION_ITEM, ?>> collectionAccessor, Predicate<COLLECTION_ITEM> predicate) {
        Assertions.assertNotNull(collectionAccessor, (String)"collection accessor must not be null", (Object[])new Object[0]);
        Assertions.assertNotNull(predicate, (String)"predicate must not be null", (Object[])new Object[0]);
        return n -> ((IDoCollection)collectionAccessor.apply(n)).findFirst(predicate) != null;
    }

    public static <DO_ENTITY, COLLECTION_ITEM> Predicate<DO_ENTITY> notExists(Function<DO_ENTITY, IDoCollection<COLLECTION_ITEM, ?>> collectionAccessor, Predicate<COLLECTION_ITEM> predicate) {
        return DoPredicates.exists(collectionAccessor, predicate).negate();
    }

    public static <DO_ENTITY, COLLECTION_ITEM> Predicate<DO_ENTITY> empty(Function<DO_ENTITY, IDoCollection<COLLECTION_ITEM, ?>> collectionAccessor) {
        Assertions.assertNotNull(collectionAccessor, (String)"collection accessor must not be null", (Object[])new Object[0]);
        return n -> ((IDoCollection)collectionAccessor.apply(n)).get().isEmpty();
    }

    public static <DO_ENTITY, COLLECTION_ITEM> Predicate<DO_ENTITY> notEmpty(Function<DO_ENTITY, IDoCollection<COLLECTION_ITEM, ?>> collectionAccessor) {
        return DoPredicates.empty(collectionAccessor).negate();
    }
}

