/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.dataobject;

import java.util.Optional;
import java.util.function.Consumer;
import org.eclipse.scout.rt.platform.util.ObjectUtility;

public class DoNode<T> {
    private String m_attributeName;
    private Consumer<DoNode<T>> m_lazyCreate;
    private T m_value;

    protected DoNode(String attributeName, Consumer<DoNode<T>> lazyCreate, T initialValue) {
        this.m_attributeName = attributeName;
        this.m_lazyCreate = lazyCreate;
        this.m_value = initialValue;
    }

    public final boolean exists() {
        return this.m_lazyCreate == null;
    }

    public final DoNode<T> create() {
        if (this.m_lazyCreate != null) {
            this.m_lazyCreate.accept(this);
            this.m_lazyCreate = null;
        }
        return this;
    }

    public T get() {
        return this.m_value;
    }

    public void set(T newValue) {
        this.create();
        this.m_value = newValue;
    }

    public final Optional<T> toOptional() {
        if (this.exists()) {
            return Optional.ofNullable(this.get());
        }
        return Optional.empty();
    }

    public final void ifPresent(Consumer<T> consumer) {
        if (this.exists()) {
            consumer.accept(this.get());
        }
    }

    protected final void setAttributeName(String attributeName) {
        this.m_attributeName = attributeName;
    }

    public final String getAttributeName() {
        return this.m_attributeName;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.exists() ? 1231 : 1237);
        result = 31 * result + (this.m_attributeName == null ? 0 : this.m_attributeName.hashCode());
        result = 31 * result + this.valueHashCode();
        return result;
    }

    protected int valueHashCode() {
        return this.m_value == null ? 0 : this.m_value.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DoNode other = (DoNode)obj;
        if (this.exists() != other.exists()) {
            return false;
        }
        if (this.m_attributeName == null ? other.m_attributeName != null : !this.m_attributeName.equals(other.m_attributeName)) {
            return false;
        }
        return this.valueEquals(other);
    }

    protected boolean valueEquals(DoNode other) {
        return ObjectUtility.equals(this.m_value, other.m_value);
    }
}

