/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.dataobject;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.scout.rt.dataobject.DataObjectHelper;
import org.eclipse.scout.rt.dataobject.DoCollection;
import org.eclipse.scout.rt.dataobject.DoList;
import org.eclipse.scout.rt.dataobject.DoNode;
import org.eclipse.scout.rt.dataobject.DoSet;
import org.eclipse.scout.rt.dataobject.DoValue;
import org.eclipse.scout.rt.dataobject.IDoEntity;
import org.eclipse.scout.rt.dataobject.IDoEntityContribution;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.StreamUtility;

public class DoEntity
implements IDoEntity {
    private final Map<String, DoNode<?>> m_attributes = new LinkedHashMap();
    private List<IDoEntity> m_contributions;

    @Override
    public DoNode<?> getNode(String attributeName) {
        return this.m_attributes.get(attributeName);
    }

    @Override
    public boolean has(String attributeName) {
        return this.m_attributes.containsKey(attributeName);
    }

    @Override
    public void putNode(String attributeName, DoNode<?> attribute) {
        IDoEntity.super.putNode(attributeName, attribute);
        this.m_attributes.put(attributeName, attribute);
    }

    @Override
    public void put(String attributeName, Object value) {
        if (this.has(attributeName)) {
            this.getValueNode(attributeName).set(value);
        } else {
            this.newValueNode(attributeName, value).create();
        }
    }

    @Override
    public <V> void putList(String attributeName, List<V> value) {
        if (this.has(attributeName)) {
            DoList<V> node = this.getListNode(attributeName);
            node.set(value);
        } else {
            this.newListNode(attributeName, value).create();
        }
    }

    @Override
    public <V> void putSet(String attributeName, Set<V> value) {
        if (this.has(attributeName)) {
            DoSet<V> node = this.getSetNode(attributeName);
            node.set(value);
        } else {
            this.newSetNode(attributeName, value).create();
        }
    }

    @Override
    public <V> void putCollection(String attributeName, Collection<V> value) {
        if (this.has(attributeName)) {
            DoCollection<V> node = this.getCollectionNode(attributeName);
            node.set(value);
        } else {
            this.newCollectionNode(attributeName, value).create();
        }
    }

    @Override
    public boolean remove(String attributeName) {
        return this.m_attributes.remove(attributeName) != null;
    }

    @Override
    public boolean removeIf(Predicate<? super DoNode<?>> filter) {
        return this.m_attributes.values().removeIf(filter);
    }

    @Override
    public Map<String, DoNode<?>> allNodes() {
        return Collections.unmodifiableMap(this.m_attributes);
    }

    @Override
    public Map<String, ?> all() {
        return this.all(Function.identity());
    }

    @Override
    public boolean hasContributions() {
        return !CollectionUtility.isEmpty(this.m_contributions);
    }

    @Override
    public Collection<IDoEntityContribution> getContributions() {
        return this.getAllContributions().stream().filter(IDoEntityContribution.class::isInstance).map(IDoEntityContribution.class::cast).collect(Collectors.toUnmodifiableList());
    }

    @Override
    @Deprecated
    public Collection<IDoEntity> getAllContributions() {
        if (this.m_contributions == null) {
            this.m_contributions = new ArrayList<IDoEntity>();
        }
        return this.m_contributions;
    }

    public boolean equals(Object o) {
        List<IDoEntity> otherContributions;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DoEntity doEntity = (DoEntity)o;
        if (!this.m_attributes.equals(doEntity.m_attributes)) {
            return false;
        }
        List<IDoEntity> contributions = this.hasContributions() ? this.m_contributions : null;
        List<IDoEntity> list = otherContributions = doEntity.hasContributions() ? doEntity.m_contributions : null;
        return CollectionUtility.equalsCollection(contributions, otherContributions, (boolean)false);
    }

    public int hashCode() {
        int result = this.m_attributes.hashCode();
        List<IDoEntity> contributions = this.hasContributions() ? this.m_contributions : null;
        result = 31 * result + CollectionUtility.hashCodeCollection(contributions);
        return result;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " " + ((DataObjectHelper)BEANS.get(DataObjectHelper.class)).toString(this);
    }

    protected <V> DoValue<V> doValue(String attributeName) {
        if (this.has(attributeName)) {
            return this.getValueNode(attributeName);
        }
        return this.newValueNode(attributeName, null);
    }

    protected <V> DoList<V> doList(String attributeName) {
        if (this.has(attributeName)) {
            return this.getListNode(attributeName);
        }
        return this.newListNode(attributeName, null);
    }

    protected <V> DoSet<V> doSet(String attributeName) {
        if (this.has(attributeName)) {
            return this.getSetNode(attributeName);
        }
        return this.newSetNode(attributeName, null);
    }

    protected <V> DoCollection<V> doCollection(String attributeName) {
        if (this.has(attributeName)) {
            return this.getCollectionNode(attributeName);
        }
        return this.newCollectionNode(attributeName, null);
    }

    protected boolean nvl(Boolean value) {
        return value != null && value != false;
    }

    protected <T> Map<String, T> all(Function<Object, T> mapper) {
        return (Map)this.allNodes().entrySet().stream().collect(StreamUtility.toLinkedHashMap(Map.Entry::getKey, entry -> mapper.apply(((DoNode)entry.getValue()).get())));
    }

    <V, NODE extends DoNode<V>> NODE getNode(String attributeName, Class<NODE> clazz) {
        Assertions.assertNotNull((Object)attributeName, (String)"attribute name cannot be null", (Object[])new Object[0]);
        DoNode<?> node = this.getNode(attributeName);
        Assertions.assertInstance(node, clazz, (String)"Node {} is null or not of type {}", (Object[])new Object[]{node, clazz});
        return (NODE)node;
    }

    <V> DoValue<V> getValueNode(String attributeName) {
        return this.getNode(attributeName, DoValue.class);
    }

    <V> DoList<V> getListNode(String attributeName) {
        return this.getNode(attributeName, DoList.class);
    }

    <V> DoSet<V> getSetNode(String attributeName) {
        return this.getNode(attributeName, DoSet.class);
    }

    <V> DoCollection<V> getCollectionNode(String attributeName) {
        return this.getNode(attributeName, DoCollection.class);
    }

    <V> DoValue<V> newValueNode(String attributeName, V initialValue) {
        return new DoValue(attributeName, attribute -> this.putNode(attributeName, (DoNode<?>)attribute), initialValue);
    }

    <V> DoCollection<V> newCollectionNode(String attributeName, Collection<V> initialValue) {
        return new DoCollection(attributeName, attribute -> this.putNode(attributeName, (DoNode<?>)attribute), initialValue);
    }

    <V> DoList<V> newListNode(String attributeName, List<V> initialValue) {
        return new DoList(attributeName, attribute -> this.putNode(attributeName, (DoNode<?>)attribute), initialValue);
    }

    <V> DoSet<V> newSetNode(String attributeName, Set<V> initialValue) {
        return new DoSet(attributeName, attribute -> this.putNode(attributeName, (DoNode<?>)attribute), initialValue);
    }
}

