/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.dataobject;

import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Consumer;
import org.eclipse.scout.rt.dataobject.AbstractDoCollection;
import org.eclipse.scout.rt.dataobject.DoNode;
import org.eclipse.scout.rt.platform.util.CollectionUtility;

public final class DoCollection<V>
extends AbstractDoCollection<V, Collection<V>> {
    public DoCollection() {
        this(null, null, null);
    }

    DoCollection(String attributeName, Consumer<DoNode<Collection<V>>> lazyCreate, Collection<V> initialValue) {
        super(attributeName, lazyCreate, DoCollection.emptyCollectionIfNull(initialValue));
    }

    public static <V> DoCollection<V> of(Collection<V> collection) {
        return new DoCollection<V>(null, null, collection);
    }

    static <V> Collection<V> emptyCollectionIfNull(Collection<V> list) {
        return list != null ? list : new ArrayList();
    }

    @Override
    public void set(Collection<V> newValue) {
        super.set(DoCollection.emptyCollectionIfNull(newValue));
    }

    @Override
    protected int valueHashCode() {
        if (!this.exists()) {
            return 0;
        }
        return CollectionUtility.hashCodeCollection((Collection)this.get(), (boolean)false);
    }

    @Override
    protected boolean valueEquals(DoNode other) {
        if (!this.exists() && !other.exists()) {
            return true;
        }
        return CollectionUtility.equalsCollection((Collection)this.get(), (Collection)((Collection)other.get()), (boolean)false);
    }

    public String toString() {
        return "DoCollection [m_collection=" + String.valueOf(this.exists() ? this.get() : "[]") + " exists=" + this.exists() + "]";
    }
}

