/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.dataobject;

import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import org.eclipse.scout.rt.dataobject.AbstractDataObjectVisitor;
import org.eclipse.scout.rt.dataobject.AbstractReplacingDataObjectVisitor;

public final class DataObjectVisitors {
    private DataObjectVisitors() {
    }

    public static <T> void forEach(Object root, Class<? extends T> elementType, Consumer<T> consumer) {
        DataObjectVisitors.forEach(root, new P_TypedElementConsumer<T>(elementType, consumer, false));
    }

    public static <T> void forEachRec(Object root, Class<? extends T> elementType, Consumer<T> consumer) {
        DataObjectVisitors.forEach(root, new P_TypedElementConsumer<T>(elementType, consumer, true));
    }

    public static <T> void forEachRecIf(Object root, Class<? extends T> elementType, Predicate<T> consumer) {
        DataObjectVisitors.forEach(root, new P_TypedElementConsumer<T>(elementType, consumer));
    }

    private static void forEach(Object root, Predicate<Object> elementConsumer) {
        new P_DataObjectVisitor(elementConsumer).visit(root);
    }

    public static <T> void replaceEach(Object root, Class<? extends T> elementType, UnaryOperator<T> operator) {
        new P_ReplaceDataObjectVisitor<T>(elementType, operator).visit(root);
    }

    private static final class P_DataObjectVisitor
    extends AbstractDataObjectVisitor {
        private final Predicate<Object> m_elementConsumer;

        private P_DataObjectVisitor(Predicate<Object> elementConsumer) {
            this.m_elementConsumer = elementConsumer;
        }

        @Override
        protected <T> void caseNode(T node, Consumer<T> chain) {
            if (this.m_elementConsumer.test(node)) {
                super.caseNode(node, chain);
            }
        }
    }

    private static final class P_ReplaceDataObjectVisitor<T>
    extends AbstractReplacingDataObjectVisitor {
        private final Class<? extends T> m_elementType;
        private final UnaryOperator<T> m_operator;

        public P_ReplaceDataObjectVisitor(Class<? extends T> elementType, UnaryOperator<T> operator) {
            this.m_elementType = elementType;
            this.m_operator = operator;
        }

        @Override
        protected <OT> OT replaceOrVisit(OT o) {
            if (this.m_elementType.isInstance(o)) {
                return (OT)this.m_operator.apply(this.m_elementType.cast(o));
            }
            return super.replaceOrVisit(o);
        }
    }

    private static final class P_TypedElementConsumer<T>
    implements Predicate<Object> {
        private final Class<? extends T> m_elementType;
        private final Predicate<T> m_elementConsumer;

        private P_TypedElementConsumer(Class<? extends T> elementType, Consumer<T> elementConsumer, boolean recursive) {
            this(elementType, o -> {
                elementConsumer.accept(o);
                return recursive;
            });
        }

        private P_TypedElementConsumer(Class<? extends T> elementType, Predicate<T> elementConsumer) {
            this.m_elementType = elementType;
            this.m_elementConsumer = elementConsumer;
        }

        @Override
        public boolean test(Object t) {
            if (this.m_elementType.isInstance(t)) {
                return this.m_elementConsumer.test(this.m_elementType.cast(t));
            }
            return true;
        }
    }
}

