/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.dataobject;

import jakarta.annotation.PostConstruct;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.eclipse.scout.rt.dataobject.AttributeName;
import org.eclipse.scout.rt.dataobject.ContributesTo;
import org.eclipse.scout.rt.dataobject.DataObjectAttributeDescriptor;
import org.eclipse.scout.rt.dataobject.DoCollection;
import org.eclipse.scout.rt.dataobject.DoList;
import org.eclipse.scout.rt.dataobject.DoSet;
import org.eclipse.scout.rt.dataobject.DoValue;
import org.eclipse.scout.rt.dataobject.IDataObjectVisitorExtension;
import org.eclipse.scout.rt.dataobject.IDoEntity;
import org.eclipse.scout.rt.dataobject.IDoEntityContribution;
import org.eclipse.scout.rt.dataobject.ITypeVersion;
import org.eclipse.scout.rt.dataobject.TypeName;
import org.eclipse.scout.rt.dataobject.TypeVersion;
import org.eclipse.scout.rt.dataobject.TypeVersionRequired;
import org.eclipse.scout.rt.dataobject.ValueFormat;
import org.eclipse.scout.rt.platform.ApplicationScoped;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.IBean;
import org.eclipse.scout.rt.platform.inventory.ClassInventory;
import org.eclipse.scout.rt.platform.inventory.IClassInfo;
import org.eclipse.scout.rt.platform.inventory.IClassInventory;
import org.eclipse.scout.rt.platform.namespace.INamespaceVersioned;
import org.eclipse.scout.rt.platform.namespace.NamespaceVersion;
import org.eclipse.scout.rt.platform.namespace.Namespaces;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.ObjectUtility;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class DataObjectInventory {
    private static final Logger LOG = LoggerFactory.getLogger(DataObjectInventory.class);
    private final Map<String, Class<? extends IDoEntity>> m_typeNameToClassMap = new HashMap<String, Class<? extends IDoEntity>>();
    private final Map<Class<? extends IDoEntity>, String> m_classToTypeName = new HashMap<Class<? extends IDoEntity>, String>();
    private final Map<Class<? extends IDoEntity>, NamespaceVersion> m_classToTypeVersion = new HashMap<Class<? extends IDoEntity>, NamespaceVersion>();
    private final Map<Class<? extends IDoEntity>, Map<String, DataObjectAttributeDescriptor>> m_classAttributeMap = new ConcurrentHashMap<Class<? extends IDoEntity>, Map<String, DataObjectAttributeDescriptor>>();
    private final Map<Class<? extends IDoEntity>, Set<Class<? extends IDoEntity>>> m_contributionClassToContainers = new HashMap<Class<? extends IDoEntity>, Set<Class<? extends IDoEntity>>>();
    private final Map<Class<? extends IDoEntity>, Set<Class<? extends IDoEntityContribution>>> m_containerClassToContributionClasses = new HashMap<Class<? extends IDoEntity>, Set<Class<? extends IDoEntityContribution>>>();
    private final Map<Class<?>, IDataObjectVisitorExtension<?>> m_visitorExtensions = new HashMap();

    @PostConstruct
    protected void init() {
        ClassInventory.get().getKnownAnnotatedTypes(TypeName.class).stream().map(IClassInfo::resolveClass).forEach(this::registerClassByTypeName);
        ClassInventory.get().getKnownAnnotatedTypes(TypeVersion.class).stream().map(IClassInfo::resolveClass).forEach(this::registerClassByTypeVersion);
        ClassInventory.get().getKnownAnnotatedTypes(ContributesTo.class).stream().map(IClassInfo::resolveClass).forEach(this::registerClassByContributesTo);
        this.validateTypeVersionImplementors();
        this.validateTypeVersionRequired();
        BEANS.all(IDataObjectVisitorExtension.class).forEach(this::registerVisitorExtension);
        LOG.info("Registry initialized, found {} {} implementations with @{} annotation and {} implementations with @{} annotation.", new Object[]{this.m_typeNameToClassMap.size(), IDoEntity.class.getSimpleName(), TypeName.class.getSimpleName(), this.m_classToTypeVersion.size(), TypeVersion.class.getSimpleName()});
    }

    public String toTypeName(Class<?> queryClazz) {
        Class<?> clazz = queryClazz;
        String name;
        while ((name = this.m_classToTypeName.get(clazz)) == null) {
            if (clazz == null || clazz == Object.class) {
                return null;
            }
            clazz = clazz.getSuperclass();
        }
        return name;
    }

    public Class<? extends IDoEntity> fromTypeName(String typeName) {
        Class<? extends IDoEntity> rawClass = this.m_typeNameToClassMap.get(typeName);
        if (rawClass != null) {
            if (BEANS.getBeanManager().isBean(rawClass)) {
                IBean bean = BEANS.getBeanManager().uniqueBean(rawClass);
                if (bean != null) {
                    return bean.getBeanClazz();
                }
                LOG.warn("Class lookup for raw class {} with type name {} is not unique, cannot lookup matching bean class!", rawClass, (Object)typeName);
            } else {
                return rawClass;
            }
        }
        return null;
    }

    public NamespaceVersion getTypeVersion(Class<? extends IDoEntity> clazz) {
        return this.m_classToTypeVersion.get(clazz);
    }

    public Set<Class<? extends IDoEntity>> getContributionContainers(Class<? extends IDoEntityContribution> contributionClass) {
        Set<Class<? extends IDoEntity>> containerClasses = this.m_contributionClassToContainers.get(contributionClass);
        return containerClasses == null ? Collections.emptySet() : Collections.unmodifiableSet(containerClasses);
    }

    public Set<Class<? extends IDoEntityContribution>> getContributionClasses(Class<? extends IDoEntity> containerClass) {
        Set<Class<? extends IDoEntityContribution>> contributionClasses = this.m_containerClassToContributionClasses.get(containerClass);
        return contributionClasses == null ? Collections.emptySet() : Collections.unmodifiableSet(contributionClasses);
    }

    public Set<Class<? extends IDoEntityContribution>> getAllContributionClasses(Class<? extends IDoEntity> containerClass) {
        HashSet<Class<? extends IDoEntity>> collectedClasses = new HashSet<Class<? extends IDoEntity>>();
        this.collectDoEntityParents(containerClass, collectedClasses);
        return collectedClasses.stream().map(clazz -> this.m_containerClassToContributionClasses.get(clazz)).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toUnmodifiableSet());
    }

    protected void collectDoEntityParents(Class<? extends IDoEntity> doEntityClass, Set<Class<? extends IDoEntity>> collectedClasses) {
        collectedClasses.add(doEntityClass);
        Class<? extends IDoEntity> superclass = doEntityClass.getSuperclass();
        if (superclass != null && IDoEntity.class.isAssignableFrom(superclass)) {
            this.collectDoEntityParents(superclass, collectedClasses);
        }
        Class<?>[] classArray = doEntityClass.getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> interfaceClass = classArray[n2];
            if (IDoEntity.class.isAssignableFrom(interfaceClass)) {
                this.collectDoEntityParents(interfaceClass, collectedClasses);
            }
            ++n2;
        }
    }

    public Map<String, Class<? extends IDoEntity>> getTypeNameToClassMap() {
        return Collections.unmodifiableMap(this.m_typeNameToClassMap);
    }

    public Optional<DataObjectAttributeDescriptor> getAttributeDescription(Class<? extends IDoEntity> entityClass, String attributeName) {
        this.ensureEntityDefinitionLoaded(entityClass);
        return Optional.ofNullable(this.m_classAttributeMap.get(entityClass).get(attributeName));
    }

    public Map<String, DataObjectAttributeDescriptor> getAttributesDescription(Class<? extends IDoEntity> entityClass) {
        this.ensureEntityDefinitionLoaded(entityClass);
        return Collections.unmodifiableMap(this.m_classAttributeMap.get(entityClass));
    }

    protected void validateTypeVersionImplementors() {
        String typeVersionsWithoutNamespaceVersion = BEANS.all(ITypeVersion.class).stream().filter(typeVersion -> typeVersion.getVersion() == null).map(Object::getClass).map(Class::getName).collect(Collectors.joining("\n"));
        Assertions.assertTrue((boolean)StringUtility.isNullOrEmpty((CharSequence)typeVersionsWithoutNamespaceVersion), (String)"Missing namespace version for implementors of {}:\n{}", (Object[])new Object[]{ITypeVersion.class.getName(), typeVersionsWithoutNamespaceVersion});
        String typeVersionsWithUnknownNamespace = BEANS.all(ITypeVersion.class).stream().filter(typeVersion -> Namespaces.get().byId(typeVersion.getVersion().getNamespace()) == null).map(Object::getClass).map(Class::getName).collect(Collectors.joining("\n"));
        Assertions.assertTrue((boolean)StringUtility.isNullOrEmpty((CharSequence)typeVersionsWithUnknownNamespace), (String)"No registered namespaces found for type versions:\n{}", (Object[])new Object[]{typeVersionsWithUnknownNamespace});
        String duplicateTypeVersions = BEANS.all(ITypeVersion.class).stream().collect(Collectors.groupingBy(INamespaceVersioned::getVersion)).entrySet().stream().filter(entry -> ((List)entry.getValue()).size() > 1).map(entry -> ((NamespaceVersion)entry.getKey()).unwrap() + ": " + ((List)entry.getValue()).stream().map(typeVersion -> typeVersion.getClass().getName()).collect(Collectors.joining(", "))).collect(Collectors.joining("\n"));
        Assertions.assertTrue((boolean)StringUtility.isNullOrEmpty((CharSequence)duplicateTypeVersions), (String)"Multiple type version classes for the same namespace version detected:\n{}", (Object[])new Object[]{duplicateTypeVersions});
    }

    protected void validateTypeVersionRequired() {
        IClassInventory classInventory = ClassInventory.get();
        String classesWithoutRequiredTypeVersion = classInventory.getKnownAnnotatedTypes(TypeVersionRequired.class).stream().map(arg_0 -> ((IClassInventory)classInventory).getAllKnownSubClasses(arg_0)).flatMap(Collection::stream).filter(ci -> ci.isInstanciable() && !ci.hasAnnotation(TypeVersion.class)).map(IClassInfo::name).distinct().collect(Collectors.joining("\n"));
        Assertions.assertTrue((boolean)StringUtility.isNullOrEmpty((CharSequence)classesWithoutRequiredTypeVersion), (String)"Missing @{} annotation for data objects due to {} on parent class/implementing interface:\n{}", (Object[])new Object[]{TypeVersion.class.getSimpleName(), TypeVersionRequired.class.getSimpleName(), classesWithoutRequiredTypeVersion});
    }

    protected void registerClassByTypeName(Class<?> clazz) {
        if (IDoEntity.class.isAssignableFrom(clazz)) {
            Class<IDoEntity> entityClass = clazz.asSubclass(IDoEntity.class);
            String name = this.resolveTypeName(clazz);
            if (StringUtility.hasText((CharSequence)name)) {
                String registeredName = this.m_classToTypeName.put(entityClass, name);
                Class<IDoEntity> registeredClass = this.m_typeNameToClassMap.put(name, entityClass);
                this.checkDuplicateClassMapping(clazz, name, registeredName, registeredClass);
                LOG.debug("Registered class {} with type name '{}'", entityClass, (Object)name);
            } else {
                LOG.warn("Class {} is annotated with @{} with an empty type name value, skip registration", (Object)clazz.getName(), (Object)TypeName.class.getSimpleName());
            }
        } else {
            LOG.warn("Class {} is annotated with @{} but is not an instance of {}, skip registration", new Object[]{clazz.getName(), TypeName.class.getSimpleName(), IDoEntity.class});
        }
    }

    protected void registerClassByTypeVersion(Class<?> clazz) {
        if (IDoEntity.class.isAssignableFrom(clazz)) {
            Class<IDoEntity> entityClass = clazz.asSubclass(IDoEntity.class);
            Class<? extends ITypeVersion> typeVersionClass = this.resolveTypeVersionClass(clazz);
            if (typeVersionClass != null) {
                ITypeVersion typeVersion = (ITypeVersion)Assertions.assertNotNull((Object)((ITypeVersion)BEANS.opt(typeVersionClass)), (String)"No instance found of '{}' for data object '{}'.", (Object[])new Object[]{typeVersionClass, clazz});
                NamespaceVersion version = typeVersion.getVersion();
                NamespaceVersion registeredVersion = this.m_classToTypeVersion.put(entityClass, version);
                Assertions.assertNull((Object)registeredVersion, (String)"{} was already registered with type version {}, register each class only once.", (Object[])new Object[]{clazz, registeredVersion, TypeVersion.class.getSimpleName()});
                LOG.debug("Registered class {} with type version '{}'", entityClass, (Object)version);
            } else {
                LOG.debug("Registered class {} without type version", entityClass);
            }
        } else {
            LOG.warn("Class {} is annotated with @{} but is not an instance of {}, skip registration", new Object[]{clazz.getName(), TypeVersion.class.getSimpleName(), IDoEntity.class});
        }
    }

    protected void registerClassByContributesTo(Class<?> clazz) {
        if (IDoEntityContribution.class.isAssignableFrom(clazz)) {
            HashSet containerClasses;
            Class<IDoEntityContribution> contributionClass = clazz.asSubclass(IDoEntityContribution.class);
            ContributesTo contributesToAnn = contributionClass.getAnnotation(ContributesTo.class);
            HashSet hashSet = containerClasses = contributesToAnn == null ? Collections.emptySet() : CollectionUtility.hashSet((Object[])contributesToAnn.value());
            if (!containerClasses.isEmpty()) {
                this.m_contributionClassToContainers.put(contributionClass, containerClasses);
                containerClasses.forEach(containerClass -> {
                    boolean bl = this.m_containerClassToContributionClasses.computeIfAbsent((Class<? extends IDoEntity>)containerClass, k -> new HashSet()).add(contributionClass);
                });
                LOG.debug("Registered class {} with containers '{}'", contributionClass, (Object)containerClasses);
            } else {
                LOG.warn("Class {} is annotated with @{} but doesn't contain any containers, skip registration", (Object)clazz.getName(), (Object)ContributesTo.class.getSimpleName());
            }
        } else {
            LOG.warn("Class {} is annotated with @{} but is not an instance of {}, skip registration", new Object[]{clazz.getName(), ContributesTo.class.getSimpleName(), IDoEntityContribution.class});
        }
    }

    protected void registerVisitorExtension(IDataObjectVisitorExtension<?> visitorExtension) {
        Class<?> valueClass = visitorExtension.valueClass();
        this.m_visitorExtensions.putIfAbsent(valueClass, visitorExtension);
        ClassInventory.get().getAllKnownSubClasses(valueClass).forEach(classInfo -> {
            IDataObjectVisitorExtension iDataObjectVisitorExtension2 = this.m_visitorExtensions.putIfAbsent(classInfo.resolveClass(), visitorExtension);
        });
    }

    protected void checkDuplicateClassMapping(Class<?> clazz, String name, String existingName, Class<? extends IDoEntity> existingClass) {
        Assertions.assertNull(existingClass, (String)"{} and {} have the same type '{}', use an unique @{} annotation value.", (Object[])new Object[]{clazz, existingClass, name, TypeName.class.getSimpleName()});
        Assertions.assertNull((Object)existingName, (String)"{} was already registered with type name {}, register each class only once.", (Object[])new Object[]{clazz, existingName, TypeName.class.getSimpleName()});
    }

    protected void ensureEntityDefinitionLoaded(Class<? extends IDoEntity> entityClass) {
        this.m_classAttributeMap.computeIfAbsent(entityClass, this::createAllAttributes);
    }

    protected Map<String, DataObjectAttributeDescriptor> createAllAttributes(Class<? extends IDoEntity> entityClass) {
        LOG.debug("Adding attributes of class {} to registry.", entityClass);
        HashMap<String, DataObjectAttributeDescriptor> attributes = new HashMap<String, DataObjectAttributeDescriptor>();
        Method[] methodArray = entityClass.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            ParameterizedType pt;
            Type returnType;
            Method method = methodArray[n2];
            if (method.getParameterCount() == 0 && !Modifier.isStatic(method.getModifiers()) && (returnType = method.getGenericReturnType()) instanceof ParameterizedType && ObjectUtility.isOneOf((Object)(pt = (ParameterizedType)returnType).getRawType(), DoValue.class, (Object[])new Object[]{DoList.class, DoSet.class, DoCollection.class})) {
                this.addAttribute(attributes, pt, method);
            }
            ++n2;
        }
        return attributes;
    }

    protected void addAttribute(Map<String, DataObjectAttributeDescriptor> attributes, ParameterizedType type, Method accessor) {
        String name = this.resolveAttributeName(accessor);
        Optional<String> formatPattern = this.resolveAttributeFormat(accessor);
        attributes.put(name, new DataObjectAttributeDescriptor(name, type, formatPattern, accessor));
        LOG.debug("Adding attribute '{}' with type {} and format pattern '{}' to registry.", new Object[]{name, type, formatPattern.orElse("null")});
    }

    protected String resolveTypeName(Class<?> c) {
        TypeName typeNameAnn = c.getAnnotation(TypeName.class);
        return typeNameAnn == null ? null : typeNameAnn.value();
    }

    protected Class<? extends ITypeVersion> resolveTypeVersionClass(Class<?> c) {
        TypeVersion typeVersionAnn = c.getAnnotation(TypeVersion.class);
        return typeVersionAnn == null ? null : typeVersionAnn.value();
    }

    protected String resolveAttributeName(Method accessor) {
        if (accessor.isAnnotationPresent(AttributeName.class)) {
            return accessor.getAnnotation(AttributeName.class).value();
        }
        return accessor.getName();
    }

    protected Optional<String> resolveAttributeFormat(Method accessor) {
        if (accessor.isAnnotationPresent(ValueFormat.class)) {
            return Optional.ofNullable(accessor.getAnnotation(ValueFormat.class).pattern());
        }
        return Optional.empty();
    }

    protected <T> IDataObjectVisitorExtension<T> getVisitorExtension(Class<T> valueClass) {
        return this.m_visitorExtensions.get(valueClass);
    }
}

