/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.dataobject;

import java.io.ByteArrayOutputStream;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import org.eclipse.scout.rt.dataobject.AbstractDataObjectVisitor;
import org.eclipse.scout.rt.dataobject.DataObjectInventory;
import org.eclipse.scout.rt.dataobject.DoCollection;
import org.eclipse.scout.rt.dataobject.DoList;
import org.eclipse.scout.rt.dataobject.DoNode;
import org.eclipse.scout.rt.dataobject.DoSet;
import org.eclipse.scout.rt.dataobject.DoValue;
import org.eclipse.scout.rt.dataobject.IDataObject;
import org.eclipse.scout.rt.dataobject.IDataObjectMapper;
import org.eclipse.scout.rt.dataobject.IDoCollection;
import org.eclipse.scout.rt.dataobject.IDoEntity;
import org.eclipse.scout.rt.dataobject.ILenientDataObjectMapper;
import org.eclipse.scout.rt.dataobject.IValueFormatConstants;
import org.eclipse.scout.rt.platform.ApplicationScoped;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.LazyValue;
import org.eclipse.scout.rt.platform.util.ObjectUtility;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.eclipse.scout.rt.platform.util.TypeCastUtility;

@ApplicationScoped
public class DataObjectHelper {
    protected final LazyValue<DataObjectInventory> m_dataObjectInventory = new LazyValue(DataObjectInventory.class);
    protected final LazyValue<IDataObjectMapper> m_dataObjectMapper = new LazyValue(IDataObjectMapper.class);
    protected final LazyValue<ILenientDataObjectMapper> m_lenientDataObjectMapper = new LazyValue(ILenientDataObjectMapper.class);

    public Integer getIntegerAttribute(IDoEntity entity, String attributeName) {
        return (Integer)TypeCastUtility.castValue((Object)entity.get(attributeName), Integer.class);
    }

    public Double getDoubleAttribute(IDoEntity entity, String attributeName) {
        return (Double)TypeCastUtility.castValue((Object)entity.get(attributeName), Double.class);
    }

    public BigInteger getBigIntegerAttribute(IDoEntity entity, String attributeName) {
        return (BigInteger)TypeCastUtility.castValue((Object)entity.get(attributeName), BigInteger.class);
    }

    public Date getDateAttribute(IDoEntity entity, String attributeName) {
        Object value = entity.get(attributeName);
        if (value instanceof String) {
            return IValueFormatConstants.parseDefaultDate.apply(value);
        }
        return (Date)TypeCastUtility.castValue((Object)value, Date.class);
    }

    public UUID getUuidAttribute(IDoEntity entity, String attributeName) {
        Object value = entity.get(attributeName);
        if (value == null) {
            return null;
        }
        if (value instanceof UUID) {
            return (UUID)value;
        }
        if (value instanceof String) {
            return UUID.fromString((String)value);
        }
        throw new IllegalArgumentException("Cannot convert value '" + String.valueOf(value) + "' to UUID");
    }

    public Locale getLocaleAttribute(IDoEntity entity, String attributeName) {
        Object value = entity.get(attributeName);
        if (value == null) {
            return null;
        }
        if (value instanceof Locale) {
            return (Locale)value;
        }
        if (value instanceof String) {
            return Locale.forLanguageTag((String)value);
        }
        throw new IllegalArgumentException("Cannot convert value '" + String.valueOf(value) + "' to Locale");
    }

    public IDoEntity getEntityAttribute(IDoEntity entity, String propertyName) {
        return entity.get(propertyName, IDoEntity.class);
    }

    public <T extends IDoEntity> T clone(T value) {
        return this.cloneInternal(value, (IDataObjectMapper)this.m_dataObjectMapper.get());
    }

    public <T extends IDoEntity> T cloneLenient(T value) {
        return this.cloneInternal(value, (IDataObjectMapper)this.m_lenientDataObjectMapper.get());
    }

    protected <T extends IDoEntity> T cloneInternal(T value, IDataObjectMapper mapper) {
        if (value == null) {
            return null;
        }
        Class<?> valueType = value.getClass();
        String clone = mapper.writeValue(value);
        return (T)((IDoEntity)mapper.readValue(clone, valueType));
    }

    public IDoEntity cloneRaw(IDoEntity value) {
        if (value == null) {
            return null;
        }
        IDataObjectMapper mapper = (IDataObjectMapper)this.m_dataObjectMapper.get();
        String clone = mapper.writeValue(value);
        return (IDoEntity)mapper.readValueRaw(clone);
    }

    public String toString(IDoEntity entity) {
        if (entity == null) {
            return Objects.toString(entity);
        }
        return ((IDataObjectMapper)this.m_dataObjectMapper.get()).writeValue(entity);
    }

    public byte[] toBytes(IDoEntity entity) {
        if (entity == null) {
            return new byte[0];
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ((IDataObjectMapper)this.m_dataObjectMapper.get()).writeValue(out, entity);
        return out.toByteArray();
    }

    public <T> T assertValue(DoValue<T> doValue) {
        Assertions.assertNotNull(doValue);
        Assertions.assertTrue((boolean)doValue.exists(), (String)"Missing mandatory attribute '{}'", (Object[])new Object[]{doValue.getAttributeName()});
        return (T)Assertions.assertNotNull(doValue.get(), (String)"Value of property '{}' must not be null", (Object[])new Object[]{doValue.getAttributeName()});
    }

    public String assertValueHasText(DoValue<String> doValue) {
        String value = this.assertValue(doValue);
        Assertions.assertTrue((boolean)StringUtility.hasText((CharSequence)value), (String)"Value of property '{}' must have text", (Object[])new Object[]{doValue.getAttributeName()});
        return value;
    }

    public void normalize(IDataObject dataObject) {
        new P_NormalizationDataObjectVisitor().normalize(dataObject);
    }

    public void clean(IDataObject dataObject) {
        new P_CleanDataObjectVisitor().clean(dataObject);
    }

    public void truncateStringValue(DoValue<String> doValue, int maxLength) {
        Assertions.assertGreater((Comparable)Integer.valueOf(maxLength), (Comparable)Integer.valueOf(0), (String)"maxLength must be greater than 0", (Object[])new Object[0]);
        if (doValue == null || !doValue.exists() || StringUtility.length((CharSequence)((CharSequence)doValue.get())) <= maxLength) {
            return;
        }
        doValue.set(((String)doValue.get()).substring(0, maxLength));
    }

    public <V> void ensureValue(DoValue<V> doValue, V value) {
        if (doValue != null && doValue.get() == null) {
            doValue.set(value);
        }
    }

    public <V> void supplyValue(DoValue<V> doValue, Supplier<V> valueSupplier) {
        if (doValue != null && valueSupplier != null && doValue.get() == null) {
            doValue.set(valueSupplier.get());
        }
    }

    public <E extends IDoEntity> E ensureDeclaredNodes(E entity) {
        if (entity == null) {
            return null;
        }
        ((DataObjectInventory)this.m_dataObjectInventory.get()).getAttributesDescription(entity.getClass()).values().forEach(desc -> this.ensureNodeValue(entity, desc.getName(), desc.getType().getRawType(), null, false));
        return entity;
    }

    public <E extends IDoEntity> E extend(E target, IDoEntity template) {
        return this.ensureNodeValues(target, template, false);
    }

    public <E extends IDoEntity> E applyValues(E target, IDoEntity template) {
        return this.ensureNodeValues(target, template, true);
    }

    protected <E extends IDoEntity> E ensureNodeValues(E target, IDoEntity template, boolean force) {
        Assertions.assertNotNull(target, (String)"target is required", (Object[])new Object[0]);
        if (template == null) {
            return target;
        }
        template.allNodes().forEach((name, node) -> this.ensureNodeValue(target, (String)name, node.getClass(), node.get(), force));
        return target;
    }

    protected void ensureNodeValue(IDoEntity entity, String attributeName, Type nodeType, Object value, boolean force) {
        if (!force && entity.has(attributeName)) {
            return;
        }
        if (nodeType == DoValue.class) {
            entity.put(attributeName, value);
        } else if (nodeType == DoList.class) {
            entity.putList(attributeName, (List)value);
        } else if (nodeType == DoSet.class) {
            entity.putSet(attributeName, (Set)value);
        } else if (nodeType == DoCollection.class) {
            entity.putCollection(attributeName, (Collection)value);
        } else {
            Assertions.fail((String)"unexpected DoNode of type [{}]", (Object[])new Object[]{nodeType.getTypeName()});
        }
    }

    protected static class P_CleanDataObjectVisitor
    extends AbstractDataObjectVisitor {
        protected P_CleanDataObjectVisitor() {
        }

        public void clean(IDataObject dataObject) {
            this.visit(dataObject);
        }

        @Override
        protected void caseDoEntity(IDoEntity entity) {
            HashSet emptyNodes = new HashSet();
            for (DoNode<?> node : entity.allNodes().values()) {
                if (node instanceof DoValue && node.get() == null) {
                    emptyNodes.add(node);
                    continue;
                }
                if (node instanceof IDoCollection && ((IDoCollection)((Object)node)).isEmpty()) {
                    emptyNodes.add(node);
                    continue;
                }
                this.caseDoEntityNode(node);
            }
            entity.removeIf(emptyNodes::contains);
            this.caseDoEntityContributions(entity.getAllContributions());
        }
    }

    protected static class P_NormalizationDataObjectVisitor
    extends AbstractDataObjectVisitor {
        protected P_NormalizationDataObjectVisitor() {
        }

        public void normalize(IDataObject dataObject) {
            this.visit(dataObject);
        }

        @Override
        protected void caseDoSet(DoSet<?> doSet) {
            super.caseDoSet(doSet);
            if (doSet.exists()) {
                this.normalizeInternal((Collection)doSet.get());
            }
        }

        @Override
        protected void caseDoCollection(DoCollection<?> doCollection) {
            super.caseDoCollection(doCollection);
            if (doCollection.exists()) {
                this.normalizeInternal((Collection)doCollection.get());
            }
        }

        @Override
        protected void caseDoEntityContributions(Collection<IDoEntity> contributions) {
            super.caseDoEntityContributions(contributions);
            this.normalizeInternal(contributions);
        }

        protected <V> void normalizeInternal(Collection<V> collection) {
            if (collection.isEmpty()) {
                return;
            }
            ArrayList<V> list = new ArrayList<V>(collection);
            boolean comparable = list.stream().allMatch(item -> item instanceof Comparable);
            if (comparable) {
                list.sort(null);
            } else {
                IDataObjectMapper mapper = (IDataObjectMapper)BEANS.get(IDataObjectMapper.class);
                IdentityHashMap jsons = new IdentityHashMap();
                list.sort((o1, o2) -> {
                    String o1Json = jsons.computeIfAbsent(o1, mapper::writeValue);
                    String o2Json = jsons.computeIfAbsent(o2, mapper::writeValue);
                    return ObjectUtility.compareTo((Comparable)((Object)o1Json), (Comparable)((Object)o2Json));
                });
            }
            collection.clear();
            collection.addAll(list);
        }
    }
}

