/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.dataobject;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.eclipse.scout.rt.dataobject.AbstractDataObjectVisitorExtension;
import org.eclipse.scout.rt.dataobject.id.ICompositeId;
import org.eclipse.scout.rt.dataobject.id.IId;
import org.eclipse.scout.rt.dataobject.id.IIds;
import org.eclipse.scout.rt.dataobject.id.IRootId;
import org.eclipse.scout.rt.platform.exception.PlatformException;

public class CompositeIdDataObjectVisitorExtension
extends AbstractDataObjectVisitorExtension<ICompositeId> {
    @Override
    public void visit(ICompositeId value, Consumer<Object> chain) {
        value.unwrap().forEach(chain);
    }

    @Override
    public ICompositeId replaceOrVisit(ICompositeId value, UnaryOperator<Object> chain) {
        List<IId> replacedComponents = value.unwrap().stream().map(chain).map(IId.class::cast).collect(Collectors.toList());
        if (replacedComponents.equals(value.unwrap())) {
            return value;
        }
        ArrayList unwrappedComponents = new ArrayList();
        replacedComponents.forEach(o -> this.unwrap((IId)o, unwrappedComponents));
        return (ICompositeId)IIds.create(value.getClass(), unwrappedComponents.toArray(new Object[0]));
    }

    protected void unwrap(IId component, List<Object> unwrappedComponents) {
        if (component instanceof IRootId) {
            unwrappedComponents.add(component.unwrap());
        } else if (component instanceof ICompositeId) {
            ((ICompositeId)component).unwrap().forEach(id -> this.unwrap((IId)id, unwrappedComponents));
        } else {
            this.handleUnknownIdTypeUnwrap(component, unwrappedComponents);
        }
    }

    protected void handleUnknownIdTypeUnwrap(IId id, List<Object> unwrappedComponents) {
        throw new PlatformException("Unsupported id type {}, cannot unwrap id {}", new Object[]{id.getClass(), id});
    }
}

