/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.dataobject;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.scout.rt.dataobject.DoNode;
import org.eclipse.scout.rt.dataobject.DoPredicates;
import org.eclipse.scout.rt.dataobject.DoValue;
import org.eclipse.scout.rt.dataobject.IDoCollection;

public abstract class AbstractDoCollection<V, COLLECTION extends Collection<V>>
extends DoNode<COLLECTION>
implements Iterable<V>,
IDoCollection<V, COLLECTION> {
    AbstractDoCollection(String attributeName, Consumer<DoNode<COLLECTION>> lazyCreate, COLLECTION initialValue) {
        super(attributeName, lazyCreate, initialValue);
    }

    @Override
    public COLLECTION get() {
        this.create();
        return (COLLECTION)((Collection)super.get());
    }

    @Override
    public boolean contains(V item) {
        if (!this.exists()) {
            return false;
        }
        return this.get().contains(item);
    }

    @Override
    public void add(V item) {
        this.get().add(item);
    }

    @Override
    public void addAll(Collection<? extends V> items) {
        if (items != null) {
            this.get().addAll(items);
        }
    }

    @Override
    @SafeVarargs
    public final void addAll(V ... items) {
        if (items != null) {
            this.addAll((Collection<? extends V>)Arrays.asList(items));
        }
    }

    @Override
    public boolean remove(V item) {
        if (!this.exists()) {
            return false;
        }
        return this.get().remove(item);
    }

    @Override
    public boolean removeAll(Collection<? extends V> items) {
        if (!this.exists()) {
            return false;
        }
        if (items != null) {
            return this.get().removeAll(items);
        }
        return false;
    }

    @Override
    @SafeVarargs
    public final boolean removeAll(V ... items) {
        if (!this.exists()) {
            return false;
        }
        if (items != null) {
            return this.removeAll((Collection<? extends V>)Arrays.asList(items));
        }
        return false;
    }

    @Override
    public void updateAll(Collection<? extends V> items) {
        this.clear();
        this.addAll(items);
    }

    @Override
    @SafeVarargs
    public final void updateAll(V ... items) {
        this.clear();
        this.addAll(items);
    }

    @Override
    public void clear() {
        if (!this.exists()) {
            return;
        }
        this.get().clear();
    }

    @Override
    public int size() {
        if (!this.exists()) {
            return 0;
        }
        return this.get().size();
    }

    @Override
    public boolean isEmpty() {
        if (!this.exists()) {
            return true;
        }
        return this.get().isEmpty();
    }

    @Override
    public Stream<V> stream() {
        if (!this.exists()) {
            return Stream.empty();
        }
        return this.get().stream();
    }

    @Override
    public Stream<V> parallelStream() {
        if (!this.exists()) {
            return Stream.empty();
        }
        return this.get().parallelStream();
    }

    @Override
    public Iterator<V> iterator() {
        if (!this.exists()) {
            return Collections.emptyIterator();
        }
        return this.get().iterator();
    }

    @Override
    public <VALUE> V findFirst(Function<V, DoValue<VALUE>> accessor, VALUE value) {
        return this.findFirst(DoPredicates.eq(accessor, value));
    }

    @Override
    public V findFirst(Predicate<V> predicate) {
        return this.stream().filter(predicate).findFirst().orElse(null);
    }

    @Override
    public <VALUE> List<V> find(Function<V, DoValue<VALUE>> accessor, VALUE value) {
        return this.find(DoPredicates.eq(accessor, value));
    }

    @Override
    public List<V> find(Predicate<V> predicate) {
        return this.stream().filter(predicate).collect(Collectors.toList());
    }
}

