/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.dataobject;

import java.util.Collection;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.scout.rt.dataobject.DataObjectInventory;
import org.eclipse.scout.rt.dataobject.DoCollection;
import org.eclipse.scout.rt.dataobject.DoList;
import org.eclipse.scout.rt.dataobject.DoNode;
import org.eclipse.scout.rt.dataobject.DoSet;
import org.eclipse.scout.rt.dataobject.IDataObjectVisitorExtension;
import org.eclipse.scout.rt.dataobject.IDoEntity;
import org.eclipse.scout.rt.platform.BEANS;

public abstract class AbstractDataObjectVisitor {
    protected final DataObjectInventory m_inventory = (DataObjectInventory)BEANS.get(DataObjectInventory.class);

    protected void visit(Object o) {
        if (o == null) {
            return;
        }
        if (o instanceof Collection) {
            this.caseNode((Collection)o, this::caseCollection);
        } else if (o instanceof Map) {
            this.caseNode((Map)o, this::caseMap);
        } else if (o instanceof IDoEntity) {
            this.caseNode((IDoEntity)o, this::caseDoEntity);
        } else if (o instanceof DoList) {
            this.caseNode((DoList)o, this::caseDoList);
        } else if (o instanceof DoSet) {
            this.caseNode((DoSet)o, this::caseDoSet);
        } else if (o instanceof DoCollection) {
            this.caseNode((DoCollection)o, this::caseDoCollection);
        } else {
            this.caseNode(o, this::caseObjectWithExtension);
        }
    }

    protected <T> void caseNode(T node, Consumer<T> chain) {
        chain.accept(node);
    }

    protected void caseCollection(Collection<?> collection) {
        for (Object o : collection) {
            this.visit(o);
        }
    }

    protected void caseMap(Map<?, ?> map) {
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            this.visit(entry.getKey());
            this.visit(entry.getValue());
        }
    }

    protected void caseDoEntity(IDoEntity entity) {
        this.applyVisitorExtension(entity);
        this.caseDoEntityNodes(entity.allNodes().values());
        this.caseDoEntityContributions(entity.getAllContributions());
    }

    protected void caseDoEntityNodes(Collection<DoNode<?>> nodes) {
        for (DoNode<?> node : nodes) {
            this.caseDoEntityNode(node);
        }
    }

    protected void caseDoEntityNode(DoNode<?> node) {
        if (node instanceof DoList) {
            this.caseDoList((DoList)node);
        } else if (node instanceof DoSet) {
            this.caseDoSet((DoSet)node);
        } else if (node instanceof DoCollection) {
            this.caseDoCollection((DoCollection)node);
        } else {
            this.visit(node.get());
        }
    }

    protected void caseDoEntityContributions(Collection<IDoEntity> contributions) {
        for (IDoEntity contribution : contributions) {
            this.visit(contribution);
        }
    }

    protected void caseDoList(DoList<?> doList) {
        for (Object o : doList) {
            this.visit(o);
        }
    }

    protected void caseDoSet(DoSet<?> doSet) {
        for (Object o : doSet) {
            this.visit(o);
        }
    }

    protected void caseDoCollection(DoCollection<?> doCollection) {
        for (Object o : doCollection) {
            this.visit(o);
        }
    }

    protected void caseObjectWithExtension(Object o) {
        this.applyVisitorExtension(o);
        this.caseObject(o);
    }

    protected void applyVisitorExtension(Object o) {
        if (o == null) {
            return;
        }
        IDataObjectVisitorExtension<?> visitorExtension = this.m_inventory.getVisitorExtension(o.getClass());
        if (visitorExtension != null) {
            visitorExtension.visit(o, this::visit);
        }
    }

    protected void caseObject(Object o) {
    }
}

