/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.api.data.table;

import java.util.List;
import java.util.function.Consumer;
import org.eclipse.scout.rt.api.data.table.LimitedResultInfoContributionDo;
import org.eclipse.scout.rt.api.data.table.MaxRowCountContributionDo;
import org.eclipse.scout.rt.dataobject.IDoEntity;
import org.eclipse.scout.rt.platform.ApplicationScoped;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.NumberUtility;

@ApplicationScoped
public class MaxResultsHelper {
    public static final int DEFAULT_MAX_RESULTS = 2000;

    public ResultLimiter limiter(IDoEntity dataObject) {
        return this.limiter(this.getMaxResultsHintFromContribution(dataObject));
    }

    public int getMaxResultsHintFromContribution(IDoEntity dataObject) {
        Integer maxRowCount;
        MaxRowCountContributionDo maxRowCountContributionDo;
        if (dataObject != null && (maxRowCountContributionDo = (MaxRowCountContributionDo)dataObject.getContribution(MaxRowCountContributionDo.class)) != null && (maxRowCount = maxRowCountContributionDo.getHint()) != null && maxRowCount > 0) {
            return maxRowCount;
        }
        return -1;
    }

    public ResultLimiter limiter(Integer requestedMaxResults) {
        return this.createResultLimiter(this.getMaxResultLimit(), NumberUtility.nvl((Integer)requestedMaxResults, (int)-1));
    }

    protected ResultLimiter createResultLimiter(int maxResultsLimit, int requestedMaxResults) {
        return new ResultLimiter(maxResultsLimit, requestedMaxResults);
    }

    public int getMaxResultLimit() {
        return 2000;
    }

    public static class ResultLimiter {
        private int m_maxResultsLimit;
        private int m_requestedMaxResults;
        private int m_estimatedRowCount;

        public ResultLimiter(int maxResultsLimit) {
            this(maxResultsLimit, -1);
        }

        public ResultLimiter(int maxResultsLimit, int requestedMaxResults) {
            this(maxResultsLimit, requestedMaxResults, -1);
        }

        public ResultLimiter(int maxResultsLimit, int requestedMaxResults, int estimatedRowCount) {
            this.setMaxResultsLimit(maxResultsLimit);
            this.setRequestedMaxResults(requestedMaxResults);
            this.setEstimatedRowCount(estimatedRowCount);
        }

        public int getQueryLimit() {
            return this.getMaxResults() + 1;
        }

        public int getMaxResults() {
            int requestedMaxResults = this.getRequestedMaxResults();
            int maxResultsLimit = this.getMaxResultsLimit();
            if (requestedMaxResults <= 0) {
                return maxResultsLimit;
            }
            return Math.min(requestedMaxResults, maxResultsLimit);
        }

        public <E, L extends List<E>> L limit(L data, IDoEntity response) {
            Consumer<Boolean> limitedResultsConsumer = null;
            LimitedResultInfoContributionDo contribution = null;
            if (response != null) {
                contribution = ((LimitedResultInfoContributionDo)response.contribution(LimitedResultInfoContributionDo.class)).withMaxRowCount(this.getMaxResultsLimit()).withEstimatedRowCount(-1);
                limitedResultsConsumer = contribution::withLimitedResult;
            }
            L result = this.limit(data, limitedResultsConsumer);
            if (contribution != null && contribution.isLimitedResult()) {
                contribution.withEstimatedRowCount(this.getEstimatedRowCount());
            }
            return result;
        }

        public <E, L extends List<E>> L limit(L data, Consumer<Boolean> limitedResultsConsumer) {
            boolean limited = false;
            int maxResults = this.getMaxResults();
            if (data != null && data.size() > maxResults) {
                limited = true;
                data.subList(maxResults, data.size()).clear();
            }
            if (limitedResultsConsumer != null) {
                limitedResultsConsumer.accept(limited);
            }
            return data;
        }

        public int getMaxResultsLimit() {
            return this.m_maxResultsLimit;
        }

        public void setMaxResultsLimit(int maxResultsLimit) {
            Assertions.assertTrue((maxResultsLimit > 0 ? 1 : 0) != 0, (String)"maxResultsLimit must be greater than 0, but was {}.", (Object[])new Object[]{maxResultsLimit});
            this.m_maxResultsLimit = maxResultsLimit;
        }

        public int getRequestedMaxResults() {
            return this.m_requestedMaxResults;
        }

        public void setRequestedMaxResults(int requestedMaxResults) {
            this.m_requestedMaxResults = requestedMaxResults;
        }

        public int getEstimatedRowCount() {
            return this.m_estimatedRowCount;
        }

        public void setEstimatedRowCount(int estimatedRowCount) {
            this.m_estimatedRowCount = estimatedRowCount;
        }
    }
}

