/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.api.data.table;

import java.util.Optional;
import org.eclipse.scout.rt.dataobject.ContributesTo;
import org.eclipse.scout.rt.dataobject.DoEntity;
import org.eclipse.scout.rt.dataobject.DoValue;
import org.eclipse.scout.rt.dataobject.IDoEntity;
import org.eclipse.scout.rt.dataobject.IDoEntityContribution;
import org.eclipse.scout.rt.dataobject.TypeName;

@ContributesTo(value={IDoEntity.class})
@TypeName(value="scout.LimitedResultInfoContribution")
public class LimitedResultInfoContributionDo
extends DoEntity
implements IDoEntityContribution {
    public DoValue<Boolean> limitedResult() {
        return this.doValue("limitedResult");
    }

    public DoValue<Integer> maxRowCount() {
        return this.doValue("maxRowCount");
    }

    public DoValue<Integer> estimatedRowCount() {
        return this.doValue("estimatedRowCount");
    }

    public static Optional<LimitedResultInfoContributionDo> of(IDoEntity entity) {
        return Optional.ofNullable(entity).map(e -> (LimitedResultInfoContributionDo)e.getContribution(LimitedResultInfoContributionDo.class));
    }

    public static boolean isLimited(IDoEntity entity) {
        return LimitedResultInfoContributionDo.of(entity).filter(LimitedResultInfoContributionDo::isLimitedResult).isPresent();
    }

    public LimitedResultInfoContributionDo withLimitedResult(Boolean limitedResult) {
        this.limitedResult().set((Object)limitedResult);
        return this;
    }

    public Boolean getLimitedResult() {
        return (Boolean)this.limitedResult().get();
    }

    public boolean isLimitedResult() {
        return this.nvl(this.getLimitedResult());
    }

    public LimitedResultInfoContributionDo withMaxRowCount(Integer maxRowCount) {
        this.maxRowCount().set((Object)maxRowCount);
        return this;
    }

    public Integer getMaxRowCount() {
        return (Integer)this.maxRowCount().get();
    }

    public LimitedResultInfoContributionDo withEstimatedRowCount(Integer estimatedRowCount) {
        this.estimatedRowCount().set((Object)estimatedRowCount);
        return this;
    }

    public Integer getEstimatedRowCount() {
        return (Integer)this.estimatedRowCount().get();
    }
}

