/*
 * Decompiled with CFR 0.152.
 */
package org.json;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.json.JSON;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONStringer;
import org.json.JSONTokener;

public class JSONArray {
    private final List<Object> m_values;

    public JSONArray() {
        this.m_values = new ArrayList<Object>();
    }

    public JSONArray(Collection<?> copyFrom) {
        this();
        if (copyFrom != null) {
            for (Object aCopyFrom : copyFrom) {
                this.put(JSONObject.wrap(aCopyFrom));
            }
        }
    }

    public JSONArray(JSONTokener readFrom) {
        Object object = readFrom.nextValue();
        if (!(object instanceof JSONArray)) {
            throw JSON.typeMismatch(object, "JSONArray");
        }
        JSONArray jsonArray = (JSONArray)object;
        this.m_values = jsonArray.m_values;
    }

    public JSONArray(String json) {
        this(new JSONTokener(json));
    }

    public JSONArray(Object array) {
        if (!array.getClass().isArray()) {
            throw new JSONException("Not a primitive array: " + String.valueOf(array.getClass()));
        }
        int length = Array.getLength(array);
        this.m_values = new ArrayList<Object>(length);
        int i = 0;
        while (i < length) {
            this.put(JSONObject.wrap(Array.get(array, i)));
            ++i;
        }
    }

    public int length() {
        return this.m_values.size();
    }

    public JSONArray put(boolean value) {
        this.m_values.add(value);
        return this;
    }

    public JSONArray put(double value) {
        this.m_values.add(JSON.checkDouble(value));
        return this;
    }

    public JSONArray put(int value) {
        this.m_values.add(value);
        return this;
    }

    public JSONArray put(long value) {
        this.m_values.add(value);
        return this;
    }

    public JSONArray put(Object value) {
        this.m_values.add(value);
        return this;
    }

    void checkedPut(Object value) {
        if (value instanceof Number) {
            JSON.checkDouble(((Number)value).doubleValue());
        }
        this.put(value);
    }

    public JSONArray put(int index, boolean value) {
        return this.put(index, (Object)value);
    }

    public JSONArray put(int index, double value) {
        return this.put(index, (Object)value);
    }

    public JSONArray put(int index, int value) {
        return this.put(index, (Object)value);
    }

    public JSONArray put(int index, long value) {
        return this.put(index, (Object)value);
    }

    public JSONArray put(int index, Object value) {
        if (value instanceof Number) {
            JSON.checkDouble(((Number)value).doubleValue());
        }
        while (this.m_values.size() <= index) {
            this.m_values.add(null);
        }
        this.m_values.set(index, value);
        return this;
    }

    public boolean isNull(int index) {
        Object value = this.opt(index);
        return value == null || value == JSONObject.NULL;
    }

    public Object get(int index) {
        try {
            Object value = this.m_values.get(index);
            if (value == null) {
                throw new JSONException("Value at " + index + " is null.");
            }
            return value;
        }
        catch (IndexOutOfBoundsException e) {
            throw new JSONException("Index " + index + " out of range [0.." + this.m_values.size() + ")");
        }
    }

    public Object opt(int index) {
        if (index < 0 || index >= this.m_values.size()) {
            return null;
        }
        return this.m_values.get(index);
    }

    public Object remove(int index) {
        if (index < 0 || index >= this.m_values.size()) {
            return null;
        }
        return this.m_values.remove(index);
    }

    public boolean getBoolean(int index) {
        Object object = this.get(index);
        Boolean result = JSON.toBoolean(object);
        if (result == null) {
            throw JSON.typeMismatch(index, object, "boolean");
        }
        return result;
    }

    public boolean optBoolean(int index) {
        return this.optBoolean(index, false);
    }

    public boolean optBoolean(int index, boolean fallback) {
        Object object = this.opt(index);
        Boolean result = JSON.toBoolean(object);
        return result != null ? result : fallback;
    }

    public double getDouble(int index) {
        Object object = this.get(index);
        Double result = JSON.toDouble(object);
        if (result == null) {
            throw JSON.typeMismatch(index, object, "double");
        }
        return result;
    }

    public double optDouble(int index) {
        return this.optDouble(index, Double.NaN);
    }

    public double optDouble(int index, double fallback) {
        Object object = this.opt(index);
        Double result = JSON.toDouble(object);
        return result != null ? result : fallback;
    }

    public int getInt(int index) {
        Object object = this.get(index);
        Integer result = JSON.toInteger(object);
        if (result == null) {
            throw JSON.typeMismatch(index, object, "int");
        }
        return result;
    }

    public int optInt(int index) {
        return this.optInt(index, 0);
    }

    public int optInt(int index, int fallback) {
        Object object = this.opt(index);
        Integer result = JSON.toInteger(object);
        return result != null ? result : fallback;
    }

    public long getLong(int index) {
        Object object = this.get(index);
        Long result = JSON.toLong(object);
        if (result == null) {
            throw JSON.typeMismatch(index, object, "long");
        }
        return result;
    }

    public long optLong(int index) {
        return this.optLong(index, 0L);
    }

    public long optLong(int index, long fallback) {
        Object object = this.opt(index);
        Long result = JSON.toLong(object);
        return result != null ? result : fallback;
    }

    public String getString(int index) {
        Object object = this.get(index);
        String result = JSON.toString(object);
        if (result == null) {
            throw JSON.typeMismatch(index, object, "String");
        }
        return result;
    }

    public String optString(int index) {
        return this.optString(index, "");
    }

    public String optString(int index, String fallback) {
        Object object = this.opt(index);
        String result = JSON.toString(object);
        return result != null ? result : fallback;
    }

    public JSONArray getJSONArray(int index) {
        Object object = this.get(index);
        if (object instanceof JSONArray) {
            return (JSONArray)object;
        }
        throw JSON.typeMismatch(index, object, "JSONArray");
    }

    public JSONArray optJSONArray(int index) {
        Object object = this.opt(index);
        return object instanceof JSONArray ? (JSONArray)object : null;
    }

    public JSONObject getJSONObject(int index) {
        Object object = this.get(index);
        if (object instanceof JSONObject) {
            return (JSONObject)object;
        }
        throw JSON.typeMismatch(index, object, "JSONObject");
    }

    public JSONObject optJSONObject(int index) {
        Object object = this.opt(index);
        return object instanceof JSONObject ? (JSONObject)object : null;
    }

    public JSONObject toJSONObject(JSONArray names) {
        JSONObject result = new JSONObject();
        int length = Math.min(names.length(), this.m_values.size());
        if (length == 0) {
            return null;
        }
        int i = 0;
        while (i < length) {
            String name = JSON.toString(names.opt(i));
            result.put(name, this.opt(i));
            ++i;
        }
        return result;
    }

    public String join(String separator) {
        JSONStringer stringer = new JSONStringer();
        stringer.open(JSONStringer.Scope.NULL, "");
        int i = 0;
        int size = this.m_values.size();
        while (i < size) {
            if (i > 0) {
                stringer.out.append(separator);
            }
            stringer.value(this.m_values.get(i));
            ++i;
        }
        stringer.close(JSONStringer.Scope.NULL, JSONStringer.Scope.NULL, "");
        return stringer.out.toString();
    }

    public String toString() {
        try {
            JSONStringer stringer = new JSONStringer();
            this.writeTo(stringer);
            return stringer.toString();
        }
        catch (JSONException e) {
            return null;
        }
    }

    public String toString(int indentSpaces) {
        JSONStringer stringer = new JSONStringer(indentSpaces);
        this.writeTo(stringer);
        return stringer.toString();
    }

    void writeTo(JSONStringer stringer) {
        stringer.array();
        for (Object value : this.m_values) {
            stringer.value(value);
        }
        stringer.endArray();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        return ((JSONArray)o).m_values.equals(this.m_values);
    }

    public int hashCode() {
        return this.m_values.hashCode();
    }
}

