/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.nativerdf;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import org.eclipse.rdf4j.common.io.FileUtil;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.URI;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.AbstractModel;
import org.eclipse.rdf4j.model.impl.ContextStatementImpl;
import org.eclipse.rdf4j.model.impl.FilteredModel;
import org.eclipse.rdf4j.model.impl.TreeModel;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.base.SailStore;
import org.eclipse.rdf4j.sail.nativerdf.SailSourceModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class MemoryOverflowModel
extends AbstractModel {
    private static final long serialVersionUID = 4119844228099208169L;
    private static final Runtime RUNTIME = Runtime.getRuntime();
    private static final int LARGE_BLOCK = 10000;
    final Logger logger = LoggerFactory.getLogger(MemoryOverflowModel.class);
    private TreeModel memory;
    transient File dataDir;
    transient SailStore store;
    transient SailSourceModel disk;
    private long baseline = 0L;
    private long maxBlockSize = 0L;

    public MemoryOverflowModel() {
        this.memory = new TreeModel();
    }

    public MemoryOverflowModel(Model model) {
        this(model.getNamespaces());
        this.addAll(model);
    }

    public MemoryOverflowModel(Set<Namespace> namespaces, Collection<? extends Statement> c) {
        this(namespaces);
        this.addAll(c);
    }

    public MemoryOverflowModel(Set<Namespace> namespaces) {
        this.memory = new TreeModel(namespaces);
    }

    @Override
    public synchronized void closeIterator(Iterator<?> iter) {
        super.closeIterator(iter);
        if (this.disk != null) {
            this.disk.closeIterator(iter);
        }
    }

    @Override
    public synchronized Set<Namespace> getNamespaces() {
        return this.memory.getNamespaces();
    }

    @Override
    public synchronized Optional<Namespace> getNamespace(String prefix) {
        return this.memory.getNamespace(prefix);
    }

    @Override
    public synchronized Namespace setNamespace(String prefix, String name) {
        return this.memory.setNamespace(prefix, name);
    }

    @Override
    public void setNamespace(Namespace namespace) {
        this.memory.setNamespace(namespace);
    }

    @Override
    public synchronized Optional<Namespace> removeNamespace(String prefix) {
        return this.memory.removeNamespace(prefix);
    }

    @Override
    public boolean contains(Resource subj, IRI pred, Value obj, Resource ... contexts) {
        return this.getDelegate().contains(subj, pred, obj, contexts);
    }

    @Override
    public boolean add(Resource subj, IRI pred, Value obj, Resource ... contexts) {
        this.checkMemoryOverflow();
        return this.getDelegate().add(subj, pred, obj, contexts);
    }

    @Override
    public boolean remove(Resource subj, IRI pred, Value obj, Resource ... contexts) {
        return this.getDelegate().remove(subj, pred, obj, contexts);
    }

    @Override
    public int size() {
        return this.getDelegate().size();
    }

    @Override
    public Iterator<Statement> iterator() {
        return this.getDelegate().iterator();
    }

    @Override
    public boolean clear(Resource ... contexts) {
        return this.getDelegate().clear(contexts);
    }

    @Override
    public Model filter(Resource subj, IRI pred, Value obj, Resource ... contexts) {
        return new FilteredModel(this, subj, pred, obj, contexts){
            private static final long serialVersionUID = -475666402618133101L;

            @Override
            public int size() {
                return MemoryOverflowModel.this.getDelegate().filter(this.subj, this.pred, this.obj, this.contexts).size();
            }

            @Override
            public Iterator<Statement> iterator() {
                return MemoryOverflowModel.this.getDelegate().filter(this.subj, this.pred, this.obj, this.contexts).iterator();
            }

            @Override
            protected void removeFilteredTermIteration(Iterator<Statement> iter, Resource subj, IRI pred, Value obj, Resource ... contexts) {
                MemoryOverflowModel.this.removeTermIteration(iter, subj, pred, obj, contexts);
            }
        };
    }

    @Override
    public synchronized void removeTermIteration(Iterator<Statement> iter, Resource subj, IRI pred, Value obj, Resource ... contexts) {
        if (this.disk == null) {
            this.memory.removeTermIteration(iter, subj, pred, obj, contexts);
        } else {
            this.disk.removeTermIteration(iter, subj, pred, obj, contexts);
        }
    }

    protected abstract SailStore createSailStore(File var1) throws IOException, SailException;

    synchronized Model getDelegate() {
        if (this.disk == null) {
            return this.memory;
        }
        return this.disk;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        Model delegate = this.getDelegate();
        s.writeInt(delegate.size());
        for (Statement st : delegate) {
            Resource subj = st.getSubject();
            IRI pred = st.getPredicate();
            Value obj = st.getObject();
            Resource ctx = st.getContext();
            s.writeObject(new ContextStatementImpl(subj, (URI)pred, obj, ctx));
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int size = s.readInt();
        for (int i = 0; i < size; ++i) {
            this.add((Statement)s.readObject());
        }
    }

    private synchronized void checkMemoryOverflow() {
        int size;
        if (this.disk == null && (size = this.size()) >= 10000 && size % 10000 == 0) {
            long totalMemory = RUNTIME.totalMemory();
            long freeMemory = RUNTIME.freeMemory();
            long used = totalMemory - freeMemory;
            if (this.baseline > 0L) {
                long blockSize = used - this.baseline;
                if (blockSize > this.maxBlockSize) {
                    this.maxBlockSize = blockSize;
                }
                if (freeMemory < (long)(size / 10000) * this.maxBlockSize) {
                    this.overflowToDisk();
                }
            }
            this.baseline = used;
        }
    }

    private synchronized void overflowToDisk() {
        try {
            assert (this.disk == null);
            this.dataDir = this.createTempDir("model");
            this.logger.debug("memory overflow using temp directory {}", (Object)this.dataDir);
            this.store = this.createSailStore(this.dataDir);
            this.disk = new SailSourceModel(this.store){

                protected void finalize() throws Throwable {
                    MemoryOverflowModel.this.logger.debug("finalizing {}", (Object)MemoryOverflowModel.this.dataDir);
                    if (MemoryOverflowModel.this.disk == this) {
                        try {
                            MemoryOverflowModel.this.store.close();
                        }
                        catch (SailException e) {
                            MemoryOverflowModel.this.logger.error(e.toString(), (Throwable)e);
                        }
                        finally {
                            FileUtil.deltree(MemoryOverflowModel.this.dataDir);
                            MemoryOverflowModel.this.dataDir = null;
                            MemoryOverflowModel.this.store = null;
                            MemoryOverflowModel.this.disk = null;
                        }
                    }
                    super.finalize();
                }
            };
            this.disk.addAll(this.memory);
            this.memory = new TreeModel(this.memory.getNamespaces());
        }
        catch (IOException | SailException e) {
            String path = this.dataDir != null ? this.dataDir.getAbsolutePath() : "(unknown)";
            this.logger.error("Error while writing to overflow directory " + path, (Throwable)e);
        }
    }

    private File createTempDir(String name) throws IOException {
        File tmpDir;
        String tmpDirStr = System.getProperty("java.io.tmpdir");
        if (tmpDirStr != null && !(tmpDir = new File(tmpDirStr)).exists()) {
            tmpDir.mkdirs();
        }
        File tmp = File.createTempFile(name, "");
        tmp.delete();
        tmp.mkdir();
        return tmp;
    }
}

