/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.memory.model;

import org.eclipse.rdf4j.model.impl.ContextStatement;
import org.eclipse.rdf4j.sail.memory.model.MemIRI;
import org.eclipse.rdf4j.sail.memory.model.MemResource;
import org.eclipse.rdf4j.sail.memory.model.MemValue;

public class MemStatement
extends ContextStatement {
    private static final long serialVersionUID = -3073275483628334134L;
    private volatile boolean explicit;
    private volatile int sinceSnapshot;
    private volatile int tillSnapshot = Integer.MAX_VALUE;

    public MemStatement(MemResource subject, MemIRI predicate, MemValue object, MemResource context, int sinceSnapshot) {
        this(subject, predicate, object, context, true, sinceSnapshot);
    }

    public MemStatement(MemResource subject, MemIRI predicate, MemValue object, MemResource context, boolean explicit, int sinceSnapshot) {
        super(subject, predicate, object, context);
        this.setExplicit(explicit);
        this.setSinceSnapshot(sinceSnapshot);
    }

    @Override
    public MemResource getSubject() {
        return (MemResource)super.getSubject();
    }

    @Override
    public MemIRI getPredicate() {
        return (MemIRI)super.getPredicate();
    }

    @Override
    public MemValue getObject() {
        return (MemValue)super.getObject();
    }

    @Override
    public MemResource getContext() {
        return (MemResource)super.getContext();
    }

    public void setSinceSnapshot(int snapshot) {
        this.sinceSnapshot = snapshot;
    }

    public int getSinceSnapshot() {
        return this.sinceSnapshot;
    }

    public void setTillSnapshot(int snapshot) {
        this.tillSnapshot = snapshot;
    }

    public int getTillSnapshot() {
        return this.tillSnapshot;
    }

    public boolean isInSnapshot(int snapshot) {
        return snapshot >= this.sinceSnapshot && snapshot < this.tillSnapshot;
    }

    public void setExplicit(boolean explicit) {
        this.explicit = explicit;
    }

    public boolean isExplicit() {
        return this.explicit;
    }

    public void addToComponentLists() {
        this.getSubject().addSubjectStatement(this);
        this.getPredicate().addPredicateStatement(this);
        this.getObject().addObjectStatement(this);
        MemResource context = this.getContext();
        if (context != null) {
            context.addContextStatement(this);
        }
    }

    public void removeFromComponentLists() {
        this.getSubject().removeSubjectStatement(this);
        this.getPredicate().removePredicateStatement(this);
        this.getObject().removeObjectStatement(this);
        MemResource context = this.getContext();
        if (context != null) {
            context.removeContextStatement(this);
        }
    }
}

