/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.federation.algebra;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.rdf4j.query.algebra.AbstractQueryModelNode;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.QueryModelVisitor;

public abstract class AbstractNaryOperator<Expr extends QueryModelNode>
extends AbstractQueryModelNode {
    private static final long serialVersionUID = 2645544440976923085L;
    private List<Expr> args = new ArrayList<Expr>();

    public AbstractNaryOperator() {
    }

    public AbstractNaryOperator(Expr ... args) {
        this(Arrays.asList(args));
    }

    public AbstractNaryOperator(List<? extends Expr> args) {
        this();
        super.setArgs(args);
    }

    public List<? extends Expr> getArgs() {
        return new CopyOnWriteArrayList<Expr>(this.args);
    }

    public int getNumberOfArguments() {
        return this.args.size();
    }

    public Expr getArg(int idx) {
        return (Expr)(idx < this.args.size() ? (QueryModelNode)this.args.get(idx) : null);
    }

    private final void addArgs(List<? extends Expr> args) {
        assert (args != null);
        for (QueryModelNode arg : args) {
            this.addArg(arg);
        }
    }

    public final void addArg(Expr arg) {
        this.setArg(this.args.size(), arg);
    }

    private final void setArgs(List<? extends Expr> args) {
        this.args.clear();
        this.addArgs(args);
    }

    protected final void setArg(int idx, Expr arg) {
        if (arg != null) {
            arg.setParentNode(this);
        }
        while (this.args.size() <= idx) {
            this.args.add(null);
        }
        this.args.set(idx, arg);
    }

    public boolean removeArg(Expr arg) {
        return this.args.remove(arg);
    }

    @Override
    public <X extends Exception> void visitChildren(QueryModelVisitor<X> visitor) throws X {
        for (QueryModelNode arg : this.args) {
            if (arg == null) continue;
            arg.visit(visitor);
        }
    }

    @Override
    public void replaceChildNode(QueryModelNode current, QueryModelNode replacement) {
        int index = this.args.indexOf(current);
        if (index >= 0) {
            this.setArg(index, replacement);
        } else {
            super.replaceChildNode(current, replacement);
        }
    }

    @Override
    public AbstractNaryOperator<Expr> clone() {
        AbstractNaryOperator clone = (AbstractNaryOperator)super.clone();
        clone.args = new ArrayList<Expr>(this.args.size());
        for (QueryModelNode arg : this.args) {
            QueryModelNode argClone = arg == null ? null : arg.clone();
            clone.addArg(argClone);
        }
        return clone;
    }
}

