/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio.ntriples;

import java.io.IOException;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.util.Literals;
import org.eclipse.rdf4j.model.vocabulary.XMLSchema;
import org.eclipse.rdf4j.rio.helpers.BasicWriterSettings;
import org.eclipse.rdf4j.rio.helpers.NTriplesWriterSettings;

public class NTriplesUtil {
    public static Value parseValue(String nTriplesValue, ValueFactory valueFactory) throws IllegalArgumentException {
        if (nTriplesValue.startsWith("<")) {
            return NTriplesUtil.parseURI(nTriplesValue, valueFactory);
        }
        if (nTriplesValue.startsWith("_:")) {
            return NTriplesUtil.parseBNode(nTriplesValue, valueFactory);
        }
        if (nTriplesValue.startsWith("\"")) {
            return NTriplesUtil.parseLiteral(nTriplesValue, valueFactory);
        }
        throw new IllegalArgumentException("Not a legal N-Triples value: " + nTriplesValue);
    }

    public static Resource parseResource(String nTriplesResource, ValueFactory valueFactory) throws IllegalArgumentException {
        if (nTriplesResource.startsWith("<")) {
            return NTriplesUtil.parseURI(nTriplesResource, valueFactory);
        }
        if (nTriplesResource.startsWith("_:")) {
            return NTriplesUtil.parseBNode(nTriplesResource, valueFactory);
        }
        throw new IllegalArgumentException("Not a legal N-Triples resource: " + nTriplesResource);
    }

    public static IRI parseURI(String nTriplesURI, ValueFactory valueFactory) throws IllegalArgumentException {
        if (nTriplesURI.startsWith("<") && nTriplesURI.endsWith(">")) {
            String uri = nTriplesURI.substring(1, nTriplesURI.length() - 1);
            uri = NTriplesUtil.unescapeString(uri);
            return valueFactory.createIRI(uri);
        }
        throw new IllegalArgumentException("Not a legal N-Triples URI: " + nTriplesURI);
    }

    public static BNode parseBNode(String nTriplesBNode, ValueFactory valueFactory) throws IllegalArgumentException {
        if (nTriplesBNode.startsWith("_:")) {
            return valueFactory.createBNode(nTriplesBNode.substring(2));
        }
        throw new IllegalArgumentException("Not a legal N-Triples Blank Node: " + nTriplesBNode);
    }

    public static Literal parseLiteral(String nTriplesLiteral, ValueFactory valueFactory) throws IllegalArgumentException {
        int endLabelIdx;
        if (nTriplesLiteral.startsWith("\"") && (endLabelIdx = NTriplesUtil.findEndOfLabel(nTriplesLiteral)) != -1) {
            int startLangIdx = nTriplesLiteral.indexOf("@", endLabelIdx);
            int startDtIdx = nTriplesLiteral.indexOf("^^", endLabelIdx);
            if (startLangIdx != -1 && startDtIdx != -1) {
                throw new IllegalArgumentException("Literals can not have both a language and a datatype");
            }
            String label = nTriplesLiteral.substring(1, endLabelIdx);
            label = NTriplesUtil.unescapeString(label);
            if (startLangIdx != -1) {
                String language = nTriplesLiteral.substring(startLangIdx + 1);
                return valueFactory.createLiteral(label, language);
            }
            if (startDtIdx != -1) {
                String datatype = nTriplesLiteral.substring(startDtIdx + 2);
                IRI dtURI = NTriplesUtil.parseURI(datatype, valueFactory);
                return valueFactory.createLiteral(label, dtURI);
            }
            return valueFactory.createLiteral(label);
        }
        throw new IllegalArgumentException("Not a legal N-Triples literal: " + nTriplesLiteral);
    }

    private static int findEndOfLabel(String nTriplesLiteral) {
        boolean previousWasBackslash = false;
        for (int i = 1; i < nTriplesLiteral.length(); ++i) {
            char c = nTriplesLiteral.charAt(i);
            if (c == '\"' && !previousWasBackslash) {
                return i;
            }
            if (c == '\\' && !previousWasBackslash) {
                previousWasBackslash = true;
                continue;
            }
            if (!previousWasBackslash) continue;
            previousWasBackslash = false;
        }
        return -1;
    }

    public static String toNTriplesString(Value value) {
        return NTriplesUtil.toNTriplesString(value, (boolean)BasicWriterSettings.XSD_STRING_TO_PLAIN_LITERAL.getDefaultValue());
    }

    public static String toNTriplesString(Value value, boolean xsdStringToPlainLiteral) {
        if (value instanceof Resource) {
            return NTriplesUtil.toNTriplesString((Resource)value);
        }
        if (value instanceof Literal) {
            return NTriplesUtil.toNTriplesString((Literal)value, xsdStringToPlainLiteral);
        }
        throw new IllegalArgumentException("Unknown value type: " + value.getClass());
    }

    public static void append(Value value, Appendable appendable) throws IOException {
        NTriplesUtil.append(value, appendable, BasicWriterSettings.XSD_STRING_TO_PLAIN_LITERAL.getDefaultValue(), NTriplesWriterSettings.ESCAPE_UNICODE.getDefaultValue());
    }

    public static void append(Value value, Appendable appendable, boolean xsdStringToPlainLiteral, boolean escapeUnicode) throws IOException {
        if (value instanceof Resource) {
            NTriplesUtil.append((Resource)value, appendable);
        } else if (value instanceof Literal) {
            NTriplesUtil.append((Literal)value, appendable, xsdStringToPlainLiteral);
        } else {
            throw new IllegalArgumentException("Unknown value type: " + value.getClass());
        }
    }

    public static String toNTriplesString(Resource resource) {
        if (resource instanceof IRI) {
            return NTriplesUtil.toNTriplesString((IRI)resource);
        }
        if (resource instanceof BNode) {
            return NTriplesUtil.toNTriplesString((BNode)resource);
        }
        throw new IllegalArgumentException("Unknown resource type: " + resource.getClass());
    }

    public static void append(Resource resource, Appendable appendable) throws IOException {
        if (resource instanceof IRI) {
            NTriplesUtil.append((IRI)resource, appendable);
        } else if (resource instanceof BNode) {
            NTriplesUtil.append((BNode)resource, appendable);
        } else {
            throw new IllegalArgumentException("Unknown resource type: " + resource.getClass());
        }
    }

    public static String toNTriplesString(IRI uri) {
        return "<" + NTriplesUtil.escapeString(uri.toString()) + ">";
    }

    public static void append(IRI uri, Appendable appendable) throws IOException {
        appendable.append("<");
        NTriplesUtil.escapeString(uri.toString(), appendable);
        appendable.append(">");
    }

    public static String toNTriplesString(BNode bNode) {
        try {
            StringBuilder result = new StringBuilder(bNode.getID().length() + 1);
            NTriplesUtil.append(bNode, (Appendable)result);
            return result.toString();
        }
        catch (IOException e) {
            throw new RuntimeException("Should not receive IOException with StringBuilder", e);
        }
    }

    public static void append(BNode bNode, Appendable appendable) throws IOException {
        String nextId = bNode.getID();
        appendable.append("_:");
        if (nextId.isEmpty()) {
            appendable.append("genid");
            appendable.append(Integer.toHexString(bNode.hashCode()));
        } else {
            if (!NTriplesUtil.isLetter(nextId.charAt(0))) {
                appendable.append("genid");
                appendable.append(Integer.toHexString(nextId.charAt(0)));
            }
            for (int i = 0; i < nextId.length(); ++i) {
                if (NTriplesUtil.isLetterOrNumber(nextId.charAt(i))) {
                    appendable.append(nextId.charAt(i));
                    continue;
                }
                appendable.append(Integer.toHexString(nextId.charAt(i)));
            }
        }
    }

    public static String toNTriplesString(Literal lit) {
        return NTriplesUtil.toNTriplesString(lit, (boolean)BasicWriterSettings.XSD_STRING_TO_PLAIN_LITERAL.getDefaultValue());
    }

    public static String toNTriplesString(Literal lit, boolean xsdStringToPlainLiteral) {
        try {
            StringBuilder sb = new StringBuilder();
            NTriplesUtil.append(lit, sb, xsdStringToPlainLiteral);
            return sb.toString();
        }
        catch (IOException e) {
            throw new AssertionError();
        }
    }

    public static void append(Literal lit, Appendable appendable) throws IOException {
        NTriplesUtil.append(lit, appendable, BasicWriterSettings.XSD_STRING_TO_PLAIN_LITERAL.getDefaultValue());
    }

    public static void append(Literal lit, Appendable appendable, boolean xsdStringToPlainLiteral) throws IOException {
        appendable.append("\"");
        NTriplesUtil.escapeString(lit.getLabel(), appendable);
        appendable.append("\"");
        if (Literals.isLanguageLiteral(lit)) {
            appendable.append("@");
            appendable.append(lit.getLanguage().get());
        } else {
            boolean ignoreDatatype;
            IRI datatype = lit.getDatatype();
            boolean bl = ignoreDatatype = datatype.equals(XMLSchema.STRING) && xsdStringToPlainLiteral;
            if (!ignoreDatatype) {
                appendable.append("^^");
                NTriplesUtil.append(lit.getDatatype(), appendable);
            }
        }
    }

    public static boolean isLetterOrNumber(int c) {
        return NTriplesUtil.isLetter(c) || NTriplesUtil.isNumber(c);
    }

    public static boolean isLetter(int c) {
        return c >= 65 && c <= 90 || c >= 97 && c <= 122;
    }

    public static boolean isNumber(int c) {
        return c >= 48 && c <= 57;
    }

    public static String escapeString(String label) {
        try {
            StringBuilder sb = new StringBuilder(2 * label.length());
            NTriplesUtil.escapeString(label, sb);
            return sb.toString();
        }
        catch (IOException e) {
            throw new AssertionError();
        }
    }

    public static void escapeString(String label, Appendable appendable) throws IOException {
        NTriplesUtil.escapeString(label, appendable, true);
    }

    public static void escapeString(String label, Appendable appendable, boolean escapeUnicode) throws IOException {
        int labelLength = label.length();
        for (int i = 0; i < labelLength; ++i) {
            char c;
            char cInt = c = label.charAt(i);
            if (c == '\\') {
                appendable.append("\\\\");
                continue;
            }
            if (c == '\"') {
                appendable.append("\\\"");
                continue;
            }
            if (c == '\n') {
                appendable.append("\\n");
                continue;
            }
            if (c == '\r') {
                appendable.append("\\r");
                continue;
            }
            if (c == '\t') {
                appendable.append("\\t");
                continue;
            }
            if (cInt >= '\u0000' && cInt <= '\b' || cInt == '\u000b' || cInt == '\f' || cInt >= '\u000e' && cInt <= '\u001f' || cInt >= '\u007f' && cInt <= '\uffff') {
                if (escapeUnicode) {
                    appendable.append("\\u");
                    appendable.append(NTriplesUtil.toHexString(cInt, 4));
                    continue;
                }
                appendable.append(c);
                continue;
            }
            if (cInt >= '\u10000' && cInt <= '\u10ffff') {
                if (escapeUnicode) {
                    appendable.append("\\U");
                    appendable.append(NTriplesUtil.toHexString(cInt, 8));
                    continue;
                }
                appendable.append(c);
                continue;
            }
            appendable.append(c);
        }
    }

    public static String unescapeString(String s) {
        int backSlashIdx = s.indexOf(92);
        if (backSlashIdx == -1) {
            return s;
        }
        int startIdx = 0;
        int sLength = s.length();
        StringBuilder sb = new StringBuilder(sLength);
        while (backSlashIdx != -1) {
            int codePoint;
            String xx;
            sb.append(s.substring(startIdx, backSlashIdx));
            if (backSlashIdx + 1 >= sLength) {
                throw new IllegalArgumentException("Unescaped backslash in: " + s);
            }
            char c = s.charAt(backSlashIdx + 1);
            if (c == 't') {
                sb.append('\t');
                startIdx = backSlashIdx + 2;
            } else if (c == 'b') {
                sb.append('\b');
                startIdx = backSlashIdx + 2;
            } else if (c == 'n') {
                sb.append('\n');
                startIdx = backSlashIdx + 2;
            } else if (c == 'r') {
                sb.append('\r');
                startIdx = backSlashIdx + 2;
            } else if (c == 'f') {
                sb.append('\f');
                startIdx = backSlashIdx + 2;
            } else if (c == '\"') {
                sb.append('\"');
                startIdx = backSlashIdx + 2;
            } else if (c == '\'') {
                sb.append('\'');
                startIdx = backSlashIdx + 2;
            } else if (c == '\\') {
                sb.append('\\');
                startIdx = backSlashIdx + 2;
            } else if (c == 'u') {
                if (backSlashIdx + 5 >= sLength) {
                    throw new IllegalArgumentException("Incomplete Unicode escape sequence in: " + s);
                }
                xx = s.substring(backSlashIdx + 2, backSlashIdx + 6);
                try {
                    codePoint = Integer.parseInt(xx, 16);
                    sb.append(Character.toChars(codePoint));
                    startIdx = backSlashIdx + 6;
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Illegal Unicode escape sequence '\\u" + xx + "' in: " + s);
                }
            } else if (c == 'U') {
                if (backSlashIdx + 9 >= sLength) {
                    throw new IllegalArgumentException("Incomplete Unicode escape sequence in: " + s);
                }
                xx = s.substring(backSlashIdx + 2, backSlashIdx + 10);
                try {
                    codePoint = Integer.parseInt(xx, 16);
                    sb.append(Character.toChars(codePoint));
                    startIdx = backSlashIdx + 10;
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Illegal Unicode escape sequence '\\U" + xx + "' in: " + s);
                }
            } else {
                throw new IllegalArgumentException("Unescaped backslash in: " + s);
            }
            backSlashIdx = s.indexOf(92, startIdx);
        }
        sb.append(s.substring(startIdx));
        return sb.toString();
    }

    public static String toHexString(int decimal, int stringLength) {
        StringBuilder sb = new StringBuilder(stringLength);
        String hexVal = Integer.toHexString(decimal).toUpperCase();
        int nofZeros = stringLength - hexVal.length();
        for (int i = 0; i < nofZeros; ++i) {
            sb.append('0');
        }
        sb.append(hexVal);
        return sb.toString();
    }
}

