/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio.nquads;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.helpers.BasicWriterSettings;
import org.eclipse.rdf4j.rio.helpers.NTriplesWriterSettings;
import org.eclipse.rdf4j.rio.ntriples.NTriplesUtil;
import org.eclipse.rdf4j.rio.ntriples.NTriplesWriter;

public class NQuadsWriter
extends NTriplesWriter {
    public NQuadsWriter(OutputStream outputStream) {
        super(outputStream);
    }

    public NQuadsWriter(Writer writer) {
        super(writer);
    }

    @Override
    public RDFFormat getRDFFormat() {
        return RDFFormat.NQUADS;
    }

    @Override
    public void handleStatement(Statement st) throws RDFHandlerException {
        if (!this.writingStarted) {
            throw new RuntimeException("Document writing has not yet been started");
        }
        try {
            NTriplesUtil.append(st.getSubject(), (Appendable)this.writer);
            this.writer.write(" ");
            NTriplesUtil.append(st.getPredicate(), (Appendable)this.writer);
            this.writer.write(" ");
            NTriplesUtil.append(st.getObject(), this.writer, this.getWriterConfig().get(BasicWriterSettings.XSD_STRING_TO_PLAIN_LITERAL), this.getWriterConfig().get(NTriplesWriterSettings.ESCAPE_UNICODE));
            if (null != st.getContext()) {
                this.writer.write(" ");
                NTriplesUtil.append(st.getContext(), (Appendable)this.writer);
            }
            this.writer.write(" .\n");
        }
        catch (IOException e) {
            throw new RDFHandlerException(e);
        }
    }
}

