/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.repository.sparql.query;

import java.io.IOException;
import org.eclipse.rdf4j.http.client.SPARQLProtocolSession;
import org.eclipse.rdf4j.http.client.query.AbstractHTTPUpdate;
import org.eclipse.rdf4j.http.protocol.UnauthorizedException;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryInterruptedException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.UpdateExecutionException;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.sparql.query.QueryStringUtil;

public class SPARQLUpdate
extends AbstractHTTPUpdate {
    public SPARQLUpdate(SPARQLProtocolSession httpClient, String baseURI, String queryString) {
        super(httpClient, QueryLanguage.SPARQL, queryString, baseURI);
    }

    @Override
    public void execute() throws UpdateExecutionException {
        try {
            SPARQLProtocolSession client = this.getHttpClient();
            try {
                client.sendUpdate(this.getQueryLanguage(), this.getQueryString(), this.getBaseURI(), this.dataset, this.includeInferred, this.getMaxExecutionTime(), this.getBindingsArray());
            }
            catch (UnauthorizedException e) {
                throw new UpdateExecutionException(e.getMessage(), e);
            }
            catch (QueryInterruptedException e) {
                throw new UpdateExecutionException(e.getMessage(), e);
            }
            catch (MalformedQueryException e) {
                throw new UpdateExecutionException(e.getMessage(), e);
            }
            catch (IOException e) {
                throw new UpdateExecutionException(e.getMessage(), e);
            }
        }
        catch (RepositoryException e) {
            throw new UpdateExecutionException(e.getMessage(), e);
        }
    }

    @Override
    public String getQueryString() {
        return QueryStringUtil.getQueryString(this.queryString, this.getBindings());
    }
}

